<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderProduct extends Model
{
    use HasFactory;

    protected $appends = ['image_url'];

    public function getImageURLAttribute()
    {
        return $this->attributes['image_url'] = $this->image ? url('/') . '/storage/' . $this->image : null;
    }
    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }
}
