<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\{Model, SoftDeletes};

class Product extends Model
{
    use HasFactory, SoftDeletes;

    public function type()
    {
        return $this->belongsTo(Type::class, 'category');
    }

    public function cabinet()
    {
        return $this->belongsTo(Cabinet::class, 'cabinet_id');
    }

    public function color()
    {
        return $this->belongsTo(Color::class, 'color_id');
    }

    public function colorMaster()
    {
        return $this->belongsTo(ColorMaster::class, 'colorMaster_id');
    }

    public function door()
    {
        return $this->belongsTo(Door::class, 'door_style_id');
    }
    public function construction()
    {
        return $this->belongsTo(ConstructionType::class, 'construction_type');
    }
}
