<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\{Model, SoftDeletes};

class ProductCombination extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['product_id', 'tag_id', 'color_id', 'length_id', 'product_type_id', 'name', 'dimension', 'main_price', 'discount_price', 'payable_price', 'in_stock', 'status'];

    protected $appends = ['image_url'];

    public function getImageURLAttribute()
    {
        return $this->attributes['image_url'] = $this->image ? url('/') . '/' . $this->image : null;
    }
    public function productType()
    {
        return $this->belongsTo(ProductType::class, 'product_type_id');
    }
    public function product()
    {
        return $this->hasOne(Product::class, 'id', 'product_id');
    }
    public function tag()
    {
        return $this->belongsTo(Tag::class, 'tag_id');
    }
    public function length()
    {
        return $this->belongsTo(Length::class, 'length_id');
    }
    public function color()
    {
        return $this->belongsTo(Color::class, 'color_id');
    }
}
