<?php

namespace App\Traits;

use Carbon\Carbon;
use App\Models\Coupon;
use App\Models\CouponHistory;

trait ApplyCouponTrait
{
    public function applyCoupon($data)
    {
        $price = $data['price'];

        // Check coupon code
        if (Coupon::where('code', $data['coupon'])->doesntExist()) {
            return ['status' => 'error', 'message' => __('Invalid coupon code.'), 'data' => null];
        }
        if(!Auth('sanctum')->check()){
            return ['status' => 'error', 'message' => __('Login to use coupon code.'), 'data' => null];
        }

        $coupon = Coupon::where('code', $data['coupon'])->first();

        // Check coupon code status
        if (Coupon::where('code', $data['coupon'])->where('status', 1)->doesntExist()) {
            return ['status' => 'error', 'message' => __('Currently coupon code is deactivated.'), 'data' => null];
        }

        // Check coupon code existence
        $current_date = Carbon::now()->format('Y-m-d');
        if (Coupon::where('code', $data['coupon'])->where('start_date', '<=', $current_date)
            ->where('end_date', '>=', $current_date)->doesntExist()
        ) {
            return ['status' => 'error', 'message' => __('Coupon expired.'), 'data' => null];
        }

        // Payable amount check
        if (Coupon::where('code', $data['coupon'])->whereNot('payable_amount', '>', (float)$price)->doesntExist()) {
            return ['status' => 'error', 'message' => __('Payable amount is low.'), 'data' => null];
        }

        // Check total coupon usage
        if (CouponHistory::where('coupon_id', $coupon->id)->count() >= $coupon->uses) {
            return ['status' => 'error', 'message' => __('Limit expired of ' . $data['coupon'] . ' coupon code.'), 'data' => null];
        }

        // Check total coupon users
        if (CouponHistory::where('coupon_id', $coupon->id)->count() >= $coupon->users) {
            return ['status' => 'error', 'message' => __($coupon->users . ' customer(s) already used ' . $data['coupon'] . ' coupon code.'), 'data' => null];
        }

        // Check total coupon user usage
        if (CouponHistory::where('coupon_id', $coupon->id)->where('user_id', auth()->id())->count() >= $coupon->users_uses) {
            return ['status' => 'error', 'message' => __('You have already used ' . $data['coupon'] . ' coupon code ' . $coupon->users_uses . ' time(s)'), 'data' => null];
        }

        // Calculating discount
        if ($coupon->type === 1) {
            $details['coupon_discount'] = $coupon->discount;
            $details['payable_amount'] = $price - $coupon->discount;
        } else {
            $details['coupon_discount'] = $price * $coupon->discount / 100;
            $details['payable_amount'] = $price - $details['coupon_discount'];
        }
        return ['status' => 'ok', 'message' => __('Success'), 'data' => $details];
    }
}
