<?php

namespace App\Traits;

use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

trait ImageUploadTrait
{
    public function save($data)
    {
        // Delete old image
        if (!empty($data['old_image'])) {
            $filePath = public_path($data['old_image']);
            if (file_exists($filePath)) {
                unlink($filePath);
            }
        }
        $image = uniqid() . '.' . $data['image']->getClientOriginalExtension();
        $data['image']->move(public_path($data['path']), $image);
        return $data['save_path'] . '/' . $image;
    }

    public function uploda($path, $save_path, $image)
    {
        $imageName = uniqid() . '.' . $image->extension();
        $image->storeAs($path, $imageName);
        return $save_path . '/' . $imageName;
    }
    /*** Image Upload Base64 Code ***/
    public function base64($base64_image)
    {
        // Get extension
        $extension = explode('/', explode(':', substr($base64_image, 0, strpos($base64_image, ';')))[1])[1];
        $replace = substr($base64_image, 0, strpos($base64_image, ',') + 1);
        $image = str_replace($replace, '', $base64_image);
        $image = str_replace(' ', '+', $image);

        // Give image a name
        $imageName = Str::random(10) . '.' . $extension;

        // Store in public folder (or public_html in live server)
        file_put_contents(public_path('product/' . $imageName), base64_decode($image));
        return $imageName;
    }
}
