<?php

namespace App\Traits;

use Illuminate\Support\Facades\App;

trait MyFatoorah
{
    // Create payment url
    public function createPayment($payment)
    {
        $payment_data = array();

        if (App::environment('local')) {
            $paymenturl = config('services.myfatoora.local.api_url');
            $token = config('services.myfatoora.local.api_key');
            $successUrl = config('services.myfatoora.local.success_url');
            $faildUrl = config('services.myfatoora.local.error_url');
        } elseif (App::environment('staging')) {
            $paymenturl = config('services.myfatoora.staging.api_url');
            $token = config('services.myfatoora.staging.api_key');
            $successUrl = config('services.myfatoora.staging.success_url');
            $faildUrl = config('services.myfatoora.staging.error_url');
        } else {
            $paymenturl = config('services.myfatoora.production.api_url');
            $token = config('services.myfatoora.production.api_key');
            $successUrl = config('services.myfatoora.production.success_url');
            $faildUrl = config('services.myfatoora.production.error_url');
        }

        $payment_data = '{'
            . '"PaymentMethodId": "' . $payment['payment_method_id'] . '",'
            . '"CustomerName": "' . $payment['name'] . '",'
            . '"DisplayCurrencyIso": "KWD",'
            . '"MobileCountryCode": "+965",'
            . '"CustomerMobile": "' . $payment['mobile'] . '",'
            . '"CustomerEmail": "' . $payment['email'] . '",'
            . '"InvoiceValue": ' . $payment['price'] . ','
            . '"Language": "en",'
            . '"CustomerReference": "' . $payment['booking_id'] . '",'
            . '"CustomerCivilId": "' . $payment['booking_id'] . '",'
            . '"UserDefinedField": "custom field",'
            . '"CallBackUrl": "' . $successUrl . '",'
            . '"ErrorUrl": "' . $faildUrl . '",'
            . '"CustomerAddress":'
            . '{'
            . '"Block": "string",'
            . '"Street": "string",'
            . '"HouseBuildingNo": "string",'
            . '"AddressInstructions": "string"'
            . '},'
            . '}';


        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "$paymenturl/v2/ExecutePayment",
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $payment_data,
            CURLOPT_HTTPHEADER => array("Authorization: Bearer $token", "Content-Type: application/json"),
        ));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $paymentResponse = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        $response_data = json_decode($paymentResponse, true);

        if (isset($response_data['IsSuccess']) && $response_data['IsSuccess']) {
            $data = array("booking_id" => $payment['booking_id'], "payment_url" => $response_data['Data']['PaymentURL']);
            $response = ['status' => 'ok', 'message' => 'Payment URL Generated successfully.', 'data' => $data];
        } else {
            $response = ['status' => 'error', 'errors' => $err, 'data' => $response_data];
        }
        return $response;
    }

    // Check payment response
    public function paymentResponse($return = array())
    {
        if (App::environment('local')) {
            $paymenturl = config('services.myfatoora.local.api_url');
            $token = config('services.myfatoora.local.api_key');
        } elseif (App::environment('staging')) {
            $paymenturl = config('services.myfatoora.staging.api_url');
            $token = config('services.myfatoora.staging.api_key');
        } else {
            $paymenturl = config('services.myfatoora.production.api_url');
            $token = config('services.myfatoora.production.api_key');
        }

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "$paymenturl/v2/GetPaymentStatus",
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => '{
              "Key": "' . $return['paymentId'] . '",
              "KeyType": "paymentId"
            }',
            CURLOPT_HTTPHEADER => array("Authorization: Bearer $token", "Content-Type: application/json"),
        ));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $res = curl_exec($curl);
        $err = curl_error($curl);
        $json_decode = json_decode($res, true);
        if (empty($err)) {
            if ($json_decode['Data']['InvoiceTransactions'][0]['TransactionStatus'] != 'Failed') {
                $response = ['status' => 'ok', 'msg' => 'Payment Done', 'data' => $res];
            } else {
                $response = ['status' => 'error', 'msg' => 'Payment Failed!', 'data' => $res];
            }
        } else {
            $response = ['status' => 'error', 'msg' => 'Payment Failed!', 'data' => $res];
        }
        return $response;
    }
}
