<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\MetaSeo>
 */
class MetaSeoFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            //
        ];
    }
    public function row($index)
    {
        return $this->state(function (array $attributes) use ($index) {
            if ($index == 1) {
                $page_name = 'home';
                $meta_title = 'Kitchen Cabinet Store & Design in Atlanta, GA';
                $meta_description = 'Discover top-quality kitchen cabinets in Atlanta, Georgia. Custom cabinetry design and expert kitchen and bath solutions to transform your home today!';
                $meta_keywords = 'Custom cabinetry design Atlanta, Georgia,Kitchen and bath specialists Atlanta, Georgia, Kitchen Cabinet Store Atlanta, Georgia';
            } elseif ($index == 2) {
                $page_name = 'kitchen-cabinet-gallery';
                $meta_title = 'Kitchen Cabinets Atlanta GA | Shaker & European Styles';
                $meta_description = 'Visit our kitchen cabinet store in Atlanta GA for cheap kitchen cabinets in shaker and European styles. Quality meets affordability.';
                $meta_keywords = 'Kitchen Cabinet Solutions in Atlanta, Georgia';
            }

            return [
                'page_name' => $page_name,
                'meta_title' => $meta_title,
                'meta_description' => $meta_description,
                'meta_keywords' => $meta_keywords,
            ];
        });
    }
}
