<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Model>
 */
class PaymentModeFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [];
    }

    public function row($index)
    {
        return $this->state(function (array $attributes) use ($index) {
            if ($index == 1) {
                $name = 'Cash';
                $sort_order = 1;
                $status = 0;
            } else if ($index == 2) {
                $name = 'Strip';
                $sort_order = 2;
                $status = 1;
            }

            return [
                'name' => $name,
                'sort_order' => $sort_order,
                'status' => $status,
            ];
        });
    }
}
