<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->string('invoice_prefix')->nullable()->comment('NI-');
            $table->bigInteger('invoice_no')->nullable()->comment('1');
            $table->string('invoice_id')->nullable()->comment('NI-1');
            $table->integer('order_id')->nullable();
            $table->integer('order_package_id')->nullable();
            $table->string('transaction_id')->nullable();
            $table->dateTime('transaction_date')->nullable();
            $table->string('currency_code')->nullable();
            $table->double('amount', 10, 3)->nullable();
            $table->tinyInteger('payment_mode_id')->nullable();
            $table->tinyInteger('payment_status')->nullable()->comment('0 = Initialized, 1 = Success, 2 = Failed');
            $table->string('token')->nullable()->comment('For internal use');
            $table->string('payment_token')->nullable()->comment('provided by payment gateway');
            $table->integer('created_by')->nullable()->comment('created by used: id');
            $table->longText('payment_details')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoices');
    }
};
