<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('site_name')->nullable();
            $table->string('site_logo')->nullable();
            $table->string('site_fav_icon')->nullable();
            $table->string('copyright')->nullable();
            $table->text('footer_text')->nullable();
            $table->string('facebook')->nullable();
            $table->string('twitter')->nullable();
            $table->string('linkedin')->nullable();
            $table->string('instagram')->nullable();
            $table->string('phone_call')->nullable();
            $table->string('phone_whatsapp')->nullable();
            $table->string('email')->nullable();
            $table->string('address')->nullable();
            $table->longText('address1')->nullable();
            $table->string('time')->nullable();
            $table->double('delivery_charge', 10, 2)->nullable();
            $table->longText('map')->nullable();
            $table->longText('map1')->nullable();
            $table->longText('descraption')->nullable();
            $table->longText('google_plus_alpharetta')->nullable();
            $table->longText('google_plus_norcross')->nullable();
            $table->longText('google_review_alpharetta')->nullable();
            $table->longText('google_review_norcross')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settings');
    }
};
