<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_otps', function (Blueprint $table) {
            $table->id();
            $table->integer('verification_for')->nullable()->comment('1: new reqistration, 2:forgot password');
            $table->integer('user_id')->nullable()->comment('user table id');
            $table->integer('verification_type')->nullable()->comment('1: verify email, 2: verify phone');
            $table->string('email')->nullable();
            $table->string('number')->nullable();
            $table->string('otp')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_otps');
    }
};
