<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->integer('cabinet_id')->nullable()->comment('cabinets table id');
            $table->string('name')->nullable();
            $table->string('background_image')->nullable();
            $table->string('model_number')->nullable();
            $table->string('pdf')->nullable();
            $table->string('video_link')->nullable();
            $table->string('information')->nullable();
            $table->integer('category')->nullable()->comment('1: Kitchen cabinets,2: Bathroom vanities');
            $table->longText('color_id')->nullable()->comment('colors table id');
            $table->integer('door_style_id')->nullable()->comment('door_styles table id');
            $table->string('construction_type')->nullable();
            $table->decimal('min_price', 10, 2)->nullable();
            $table->decimal('max_price', 10, 2)->nullable();
            $table->decimal('main_price', 10, 2)->nullable();
            $table->decimal('discount_price', 10, 2)->nullable();
            $table->text('description')->nullable();
            $table->text('measurements')->nullable();
            $table->text('key_features')->nullable();
            $table->text('return_policies')->nullable();
            $table->integer('status')->default(1)->comment('1: active,2: inactive');
            $table->integer('sort_order')->nullable();
            $table->integer('quick_shipping')->default(2)->comment('1: Quick Shipping,2: Not Quick Shipping')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
};
