<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_combinations', function (Blueprint $table) {
            $table->id();
            $table->integer('product_id')->nullable()->comment('products table id');
            $table->integer('tag_id')->nullable()->comment('tags table id');
            $table->integer('color_id')->nullable()->comment('colors table id');
            $table->integer('length_id')->nullable()->comment('lengths table id');
            $table->string('image')->nullable();
            $table->string('name')->nullable();
            $table->string('dimension')->nullable();
            $table->decimal('main_price', 10, 2)->nullable();
            $table->decimal('discount_price', 10, 2)->nullable();
            $table->decimal('payable_price', 10, 2)->nullable();
            $table->integer('in_stock')->default(1)->comment('1: yes,2: no');
            $table->integer('status')->default(1)->comment('1: active,2: inactive');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_combinations');
    }
};
