<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('banners', function (Blueprint $table) {
            $table->id();
            $table->string('image')->nullable();
            $table->longText('title1')->nullable();
            $table->longText('title2')->nullable();
            $table->longText('title3')->nullable();
            $table->longText('title4')->nullable();
            $table->longText('title5')->nullable();
            $table->longText('title6')->nullable();
            $table->longText('title7')->nullable();
            $table->string('title')->nullable();
            $table->longText('description')->nullable();
            $table->string('color')->nullable();
            $table->integer('status')->default(1)->comment('1: active,2: inactive')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('banners');
    }
};
