<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('galleries', function (Blueprint $table) {
            $table->id();
            $table->integer('type')->default(1)->comment('1: category,2: serviceMaster')->nullable();
            $table->integer('ourservisesmaster_id')->comment('Our services master id')->nullable();
            $table->integer('type_id')->comment('Type id')->nullable();
            $table->string('image')->nullable();
            $table->integer('status')->default(1)->comment('1: active,2: inactive')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('galleries');
    }
};
