<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('carts', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->nullable()->comment('users table id');
            $table->string('token')->nullable();
            $table->integer('product_id')->nullable()->comment('products table id');
            $table->integer('color_id')->nullable()->comment('colors table id');
            $table->integer('length_id')->nullable()->comment('length table id');
            $table->integer('product_combination_id')->nullable()->comment('product_combinations table id');
            $table->integer('quantity')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('carts');
    }
};
