<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('order_prefix')->nullable()->comment('KC-');
            $table->bigInteger('order_no')->nullable()->comment('1');
            $table->string('order_id')->nullable()->comment('KC-1');
            $table->integer('user_id')->nullable()->comment('users table id');
            $table->double('total', 10, 3)->nullable();
            $table->double('sub_total', 10, 3)->nullable();
            $table->double('coupon_discount', 10, 3)->nullable();
            $table->double('delivery_charge', 10, 3)->nullable();
            $table->integer('payment_mode_id')->nullable()->comment('payment_modes table id');
            $table->integer('payment_status_id')->default(1)->comment('payment_status table id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
};
