<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_products', function (Blueprint $table) {
            $table->id();
            $table->integer('order_id')->nullable()->comment('orders table id');
            $table->integer('product_id')->nullable()->comment('products table id');
            $table->integer('product_combinition_id')->nullable()->comment('product_combinitions table id');
            $table->integer('tag_id')->nullable()->comment('tags table id');
            $table->integer('color_id')->nullable()->comment('colors table id');
            $table->integer('length_id')->nullable()->comment('length table id');
            $table->integer('product_type_id')->nullable()->comment('product type table id');
            $table->string('product_type_name')->nullable();
            $table->string('tag_name')->nullable();
            $table->string('color_name')->nullable();
            $table->string('length_name')->nullable();
            $table->string('image')->nullable();
            $table->string('name')->nullable();
            $table->string('dimension')->nullable();
            $table->decimal('main_price', 10, 2)->nullable();
            $table->decimal('discount_price', 10, 2)->nullable();
            $table->decimal('payable_price', 10, 2)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_products');
    }
};
