<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quotes', function (Blueprint $table) {
            $table->id();
            $table->string('image')->nullable();
            $table->string('name')->nullable();
            $table->string('company_name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('your_space')->nullable();
            $table->longText('project')->nullable();
            $table->longText('interested')->nullable();
            $table->string('cabinet')->nullable();
            $table->string('countertop')->nullable();
            $table->string('sink')->nullable();
            $table->string('location')->nullable();
            $table->string('project_type')->nullable();
            $table->string('project_timeline')->nullable();
            $table->string('budget_range')->nullable();
            $table->longText('messages')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quotes');
    }
};
