<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('color_masters', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->longText('color_id')->nullable()->comment('colors table id');
            $table->integer('status')->default(1)->comment('1: active,2: inactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('color_masters');
    }
};
