<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('discount_products', function (Blueprint $table) {
            $table->id();
            $table->integer('category')->nullable()->comment('category table id');
            $table->integer('color_master_id')->comment('color master table id')->nullable();
            $table->integer('product_type_id')->nullable()->comment('product_types table id');
            $table->integer('product_id')->comment('product table id')->nullable();
            $table->integer('product_combination_id')->comment('product combination table id')->nullable();
            $table->integer('color_id')->comment('color table id')->nullable();
            $table->integer('tag_id')->comment('tag table id')->nullable();
            $table->integer('discount')->default(1)->comment('1: increase,2: decrease');
            $table->integer('type')->default(1)->comment('1: percentage,2: amount');
            $table->text('dis_amount')->nullable();
            $table->integer('status')->default(1)->comment('1: active,0: inactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('discount_products');
    }
};
