<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Role::create(['name' => 'superadmin']);
        $superadmin = User::type(1)->first();
        $superadmin->assignRole('superadmin');

        Role::create(['name' => 'buyer']);
        $buyer1 = User::type(2)->first();
        $buyer1->assignRole('buyer');

        $buyer2 = User::type(2)->skip(1)->first();
        $buyer2->assignRole('buyer');

        Role::create(['name' => 'seller']);
        $seller1 = User::type(3)->first();
        $seller1->assignRole('seller');

        $seller2 = User::type(3)->skip(1)->first();
        $seller2->assignRole('seller');
    }
}
