@extends('backend.auth.layout.main')
@section('title', 'Log in')
@section('sections')
    <div class="login-box">
        <div class="login-logo">
            <a href="javascript:void(0)"><b>{{ env('APP_NAME') }}</b></a>
        </div>
        <div class="card">
            <div class="card-body login-card-body">
                <p class="login-box-msg">Sign in to start your session</p>
                @include('backend.common.message')
                <form action="{{ route('backend.checking.login') }}" method="post" autocomplete="off">
                    @csrf
                    <div class="input-group mb-3">
                        <input type="email" class="form-control" name="email" placeholder="Email"
                            value="superadmin@domain.com">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-envelope"></span>
                            </div>
                        </div>
                    </div>
                    <div class="input-group mb-3">
                        <input type="password" class="form-control" name="password" placeholder="Password" value="12345678">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-lock"></span>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary btn-block">Sign In</button>
                        </div>
                    </div>
                </form>

                {{-- <p class="mb-1">
                    <a href="{{ route('backend.forgot_password') }}">I forgot my password</a>
                </p> --}}
            </div>
        </div>
    </div>
@endsection
