@extends('backend.layouts.main')
@section('sections')
    <div class="content-wrapper" style="min-height: 357px;">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">CMS</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a> </li>
                            <li class="breadcrumb-item">CMS</li>
                            <li class="breadcrumb-item active">{{ $cms->title }}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">{{ $cms->title }}</h3>
                            </div>
                            <div class="card-body">
                                @if (session()->has('success'))
                                    <div class="alert alert-success">
                                        {{ session()->get('success') }}
                                    </div>
                                @endif
                                <form action="{{ route('backend.cms.update', $cms->id) }}" method="POST" autocomplete="off"
                                    enctype="multipart/form-data">
                                    {{ csrf_field() }}
                                    @method('PUT')
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Title</label>
                                                <input type="text" class="form-control" name="title"
                                                    placeholder="Title" value="{{ $cms->title }}">
                                            </div>
                                            @error('title')
                                                <div class="alert-danger">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Description</label>
                                                <textarea type="text" class="form-control" id="summernote" name="description" rows="5" placeholder="Description">{!! $cms->description !!}</textarea>
                                            </div>
                                            @error('description')
                                                <div class="alert-danger">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="col-md-12 mt-3" style="text-align: right">
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @push('scripts')
        <script>
            $(document).ready(function() {
                $('#summernote').summernote()
            });
        </script>
    @endpush
@endsection
