@php
    $segment = Request::segment(2);
    $segment3 = Request::segment(3);
    // dd($segment);
@endphp
<nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <!-- Left navbar links -->
    <ul class="navbar-nav">
        <li class="nav-item">
            <a class="nav-link" data-widget="pushmenu" href="javascript:void(0)" role="button"
                onclick="sidebarCollapse()"><i class="fas fa-bars"></i></a>
        </li>
    </ul>

    <ul class="navbar-nav ml-auto">
        <li class="nav-item">
            <a class="nav-link" data-widget="fullscreen" href="#" role="button" onclick="fullScreen()">
                <i class="fas fa-expand-arrows-alt" id="add-fa-class"></i>
            </a>
        </li>
    </ul>
</nav>

<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="{{ route('backend.dashboard') }}" class="brand-link">
        <img src="{{ asset('storage/' . SiteInfo::info()['site_logo']) }}" alt="{{ config('app.name') }}"
            class="brand-image img-circle elevation-3"style="opacity: .8">
        <span class="brand-text font-weight-light">{{ env('APP_NAME') }}</span>
    </a>

    <div class="sidebar">


        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                data-accordion="false">
                <li class="nav-item">
                    <a href="{{ route('backend.dashboard') }}"
                        class="nav-link @if ($segment == 'dashboard') active @endif">
                        <i class="nav-icon fas fa-th"></i>
                        <p>Dashboard</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('backend.product.index') }}"
                        class="nav-link @if ($segment == 'product') active @endif">
                        <i class="nav-icon fa fa-product-hunt"></i>
                        <p>Product</p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="{{ route('backend.seo.index') }}"
                        class="nav-link @if ($segment == 'seo') active @endif">
                        <i class="nav-icon fa fa-product-hunt"></i>
                        <p>Seo</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('backend.discountProduct.index') }}"
                        class="nav-link @if ($segment == 'discountProduct') active @endif">
                        <i class="nav-icon fa fa-product-hunt"></i>
                        <p>Price Adjustment</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('backend.coupon.index') }}"
                        class="nav-link @if ($segment == 'coupon') active @endif">
                        <i class="fa fa-percent" aria-hidden="true"></i>
                        <p>Coupon</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('backend.orders.index') }}"
                        class="nav-link @if ($segment == 'orders') active @endif">
                        <i class="nav-icon fa fa-shopping-cart"></i>
                        <p>Orders</p>
                    </a>
                </li>
                <li class="nav-item @if (in_array($segment, ['super-admin', 'admin', 'proMember'])) menu-open @endif">
                    <a href="#" class="nav-link @if (in_array($segment, ['super-admin', 'admin', 'proMember'])) active @endif">
                        <i class="nav-icon fas fa-users"></i>
                        <p>
                            User Type
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">

                        <li class="nav-item">
                            <a href="{{ route('backend.admin.index') }}"
                                class="nav-link @if ($segment == 'admin') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Customers</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.proMember.index') }}"
                                class="nav-link @if ($segment == 'proMember') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Pro member</p>
                            </a>
                        </li>
                    </ul>
                </li>
                <li class="nav-item @if (in_array($segment3, [
                        'banner',
                        'brandsTitle',
                        'titleHome',
                        'blog',
                        'assemblyInstruction',
                        'youtubeLink',
                        'type',
                        'gallery',
                        'cabinet',
                        'color',
                        'brand',
                        'tag',
                        'construction',
                        'colorMaster',
                        'services',
                        'member',
                        'guaranteed',
                        'store',
                        'category',
                        'faq',
                        'ourServicesMaster',
                        'about',
                        'quickShipTitle',
                        'freeDesignContent',
                        'freeDesignService',
                        'kitchen-design-tool',
                        'pricingTitle',
                        'pricingContent',
                        'length',
                    ])) menu-open @endif">
                    <a href="#" class="nav-link @if (in_array($segment3, [
                            'banner',
                            'brandsTitle',
                            'titleHome',
                            'blog',
                            'assemblyInstruction',
                            'youtubeLink',
                            'type',
                            'gallery',
                            'cabinet',
                            'color',
                            'brand',
                            'tag',
                            'construction',
                            'colorMaster',
                            'services',
                            'member',
                            'guaranteed',
                            'store',
                            'category',
                            'faq',
                            'ourServicesMaster',
                            'about',
                            'quickShipTitle',
                            'freeDesignContent',
                            'freeDesignService',
                            'kitchen-design-tool',
                            'pricingTitle',
                            'pricingContent',
                            'length',
                        ])) active @endif">
                        <i class="nav-icon fas fa-home"></i>
                        <p>
                            Master
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="{{ route('backend.banner.index') }}"
                                class="nav-link @if ($segment3 == 'banner') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Banner</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.gallery.index') }}"
                                class="nav-link @if ($segment3 == 'gallery') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Gallery</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.store.index') }}"
                                class="nav-link @if ($segment3 == 'store') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Stores</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.titleHome.index') }}"
                                class="nav-link @if ($segment3 == 'titleHome') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Title Home</p>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a href="{{ route('backend.blog.index') }}"
                                class="nav-link @if ($segment3 == 'blog') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Blog</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.quickShipTitle.index') }}"
                                class="nav-link @if ($segment3 == 'quickShipTitle') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Quick Ship
                                    Title</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.about.index') }}"
                                class="nav-link @if ($segment3 == 'about') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>About</p>
                            </a>
                        </li>
                        {{-- <li class="nav-item">
                            <a href="{{ route('backend.generalAssembly.index') }}"
                                class="nav-link @if ($segment3 == 'generalAssembly') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>General Assembly</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.generalAssemblyVideo.index') }}"
                                class="nav-link @if ($segment3 == 'generalAssemblyVideo') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>General Assembly Video</p>
                            </a>
                        </li> --}}
                        <li class="nav-item">
                            <a href="{{ route('backend.member.index') }}"
                                class="nav-link @if ($segment3 == 'member') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Member</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.guaranteed.index') }}"
                                class="nav-link @if ($segment3 == 'guaranteed') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Guaranteed</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.services.index') }}"
                                class="nav-link @if ($segment3 == 'services') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Services</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.assemblyInstruction.index') }}"
                                class="nav-link @if ($segment3 == 'assemblyInstruction') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Assembly Instructions</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.youtubeLink.index') }}"
                                class="nav-link @if ($segment3 == 'youtubeLink') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Youtube Link</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.type.index') }}"
                                class="nav-link @if ($segment3 == 'type') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Product Category</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.pricingTitle.index') }}"
                                class="nav-link @if ($segment3 == 'pricingTitle') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Pricing Title</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.pricingContent.index') }}"
                                class="nav-link @if ($segment3 == 'pricingContent') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Pricing Content</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.length.index') }}"
                                class="nav-link @if ($segment3 == 'length') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Length</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.color.index') }}"
                                class="nav-link @if ($segment3 == 'color') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Color</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.colorMaster.index') }}"
                                class="nav-link @if ($segment3 == 'colorMaster') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Color Master</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.brand.index') }}"
                                class="nav-link @if ($segment3 == 'brand') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p> Brands</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.brandsTitle.index') }}"
                                class="nav-link @if ($segment3 == 'brandsTitle') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Brand Title</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.construction.index') }}"
                                class="nav-link @if ($segment3 == 'construction') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Product Type</p>
                            </a>
                        </li>

                        {{-- <li class="nav-item">

                            <a href="{{ route('backend.kitchen.design.tool.show') }}"
                                class="nav-link @if ($segment3 == 'kitchen-design-tool') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Kitchen Design Tool</p>
                            </a>
                        </li> --}}
                        <li class="nav-item">

                            <a href="{{ route('backend.ourServicesMaster.index') }}"
                                class="nav-link @if ($segment3 == 'ourServicesMaster') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Our Servises Master</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.freeDesignContent.index') }}"
                                class="nav-link @if ($segment3 == 'freeDesignContent') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Free Design Content</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.freeDesignService.index') }}"
                                class="nav-link @if ($segment3 == 'freeDesignService') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Free Design Service</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.tag.index') }}"
                                class="nav-link @if ($segment3 == 'tag') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Tag</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.faq.index') }}"
                                class="nav-link @if ($segment3 == 'faq') active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Faq</p>
                            </a>
                        </li>
                    </ul>
                </li>
                <li class="nav-item">
                    <a href="{{ route('backend.contactFrom.index') }}"
                        class="nav-link @if ($segment3 == 'contactFrom') active @endif">
                        <i class="fa fa-eye" aria-hidden="true"></i>
                        <p>Contact From Details</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('backend.customerReview.index') }}"
                        class="nav-link @if ($segment3 == 'customerReview') active @endif">
                        <i class="fa fa-eye" aria-hidden="true"></i>
                        <p>Customer Review</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('backend.quote.index') }}"
                        class="nav-link @if ($segment3 == 'quote') active @endif">
                        <i class="nav-icon fa fa-cogs" aria-hidden="true"></i>
                        <p>Quote Request</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('backend.quickShipRequest.index') }}"
                        class="nav-link @if ($segment == 'quickShipRequest') active @endif">
                        <i class="fa fa-truck" aria-hidden="true"></i>
                        <p>Quick Ship Request</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('backend.free.design.request') }}"
                        class="nav-link @if ($segment == 'free-design-request') active @endif">
                        <i class="fa fa-envelope-open" aria-hidden="true"></i>
                        <p>Free Design Request</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('backend.pricingRequest.index') }}"
                        class="nav-link @if ($segment == 'pricingRequest') active @endif">
                        <i class="fa fa-usd" aria-hidden="true"></i>
                        <p>Pricing Request</p>
                    </a>
                </li>
                {{-- <li class="nav-item">
                    <a href="{{ route('backend.kitchen.design.request') }}"
                        class="nav-link @if ($segment == 'kitchen-design-request') active @endif">
                        <i class="fa fa-address-card" aria-hidden="true"></i>
                        <p>Kitchen Design Request</p>
                    </a>
                </li> --}}
                <li class="nav-item @if ($segment == 'ourServices') menu-open @endif">
                    <a href="#" class="nav-link @if ($segment == 'ourServices') active @endif">
                        <i class="nav-icon fa fa-rss"></i>
                        <p>
                            Our Servises
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        @if (!empty(SiteInfo::ourServices()))
                            @foreach (SiteInfo::ourServices() as $ourService)
                                <li class="nav-item">
                                    <a href="{{ route('backend.ourServices.edit', $ourService->id) }}"
                                        class="nav-link @if ($segment == 'ourServices' && $segment3 == $ourService->id) active @endif">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>{{ $ourService->name }}</p>
                                    </a>
                                </li>
                            @endforeach
                        @endif
                        <li class="nav-item">
                            <a href="{{ route('backend.ourServices.edit', 0) }}"
                                class="nav-link @if ($segment == 'ourServices' && $segment3 == 0) active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Kitchen Cabinet</p>
                            </a>
                        </li>
                    </ul>
                </li>

                <li class="nav-item @if ($segment == 'ourServicesRequest') menu-open @endif">
                    <a href="#" class="nav-link @if ($segment == 'ourServicesRequest') active @endif">
                        <i class="nav-icon fa fa-rss"></i>
                        <p>
                            Lead Form
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    @php
                        $currentURL = $_SERVER['REQUEST_URI'];
                        $getType = explode('=', parse_url($currentURL, PHP_URL_QUERY));

                        if (isset($getType[1]) && !empty($getType[1])) {
                            $type = $getType[1];
                        } else {
                            $type = null;
                        }
                    @endphp
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="{{ route('backend.ourServicesRequest.index') }}?type=0"
                                class="nav-link @if ($segment == 'ourServicesRequest' && $type == 0) active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Kitchen Cabinet</p>
                            </a>
                        </li>
                        @if (!empty(SiteInfo::ourServices()))
                            @foreach (SiteInfo::ourServices() as $ourService)
                                <li class="nav-item">
                                    <a href="{{ route('backend.ourServicesRequest.index') }}?type={{ $ourService->id }}"
                                        class="nav-link @if ($segment == 'ourServicesRequest' && $type == $ourService->id) active @endif">
                                        <i class="far fa-circle nav-icon"></i>
                                        <p>{{ $ourService->name }}</p>
                                    </a>
                                </li>
                            @endforeach
                        @endif
                    </ul>
                </li>
                <li class="nav-item">
                    <a href="{{ route('backend.ourServicesMain.edit', 1) }}"
                        class="nav-link @if ($segment == 'ourServicesMain') active @endif">
                        <i class="fa fa-truck" aria-hidden="true"></i>
                        <p>Our Services Main</p>
                    </a>
                </li>
                <li class="nav-item @if ($segment == 'cms') menu-open @endif">
                    <a href="#" class="nav-link @if ($segment == 'cms') active @endif">
                        <i class="nav-icon fa fa-rss"></i>
                        <p>
                            CMS
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="{{ route('backend.cms.edit', 1) }}"
                                class="nav-link @if ($segment == 'cms' && $segment3 == 1) active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Refund Policy</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.cms.edit', 2) }}"
                                class="nav-link @if ($segment == 'cms' && $segment3 == 2) active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Privacy Policy</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.cms.edit', 3) }}"
                                class="nav-link @if ($segment == 'cms' && $segment3 == 3) active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Terms & Services</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('backend.cms.edit', 4) }}"
                                class="nav-link @if ($segment == 'cms' && $segment3 == 4) active @endif">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Return Policy</p>
                            </a>
                        </li>
                    </ul>
                </li>
                <li class="nav-header">My Account</li>
                {{-- <li class="nav-item">
                    <a href="{{ route('backend.profile.edit', auth()->id()) }}"
                        class="nav-link @if ($segment == 'profile') active @endif">
                        <i class="nav-icon fa fa-user" aria-hidden="true"></i>
                        <p>My profile</p>
                    </a>
                </li> --}}
                <li class="nav-item">
                    <a href="{{ route('backend.settings.edit', 1) }}"
                        class="nav-link @if ($segment == 'settings') active @endif">
                        <i class="nav-icon fa fa-cogs" aria-hidden="true"></i>
                        <p>Settings</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('backend.logout') }}" class="nav-link">
                        <i class="nav-icon fa fa-sign-out" aria-hidden="true"></i>
                        <p>Logout</p>
                    </a>
                </li>
            </ul>
        </nav>
    </div>
</aside>
