@extends('backend.layouts.main')
@section('title', 'Create')
@section('sections')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Create</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('backend.banner.index') }}">Banner</a>
                            </li>
                            <li class="breadcrumb-item active">Create</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col">
                        @include('backend.common.message')
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <a class="btn btn-sm btn-secondary" href="{{ route('backend.banner.index') }}">
                            <i class="fa fa-arrow-left" aria-hidden="true"></i>
                        </a>
                    </div>
                    <form action="{{ route('backend.banner.store') }}" method="POST" autocomplete="off"
                        enctype="multipart/form-data">
                        @csrf
                        @method('POST')
                        <div class="card-body">

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="image">Image</label>
                                        <input type="file" class="form-control" id="image" name="image"
                                            class="type-1">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="title1">Title1</label>
                                        <input type="text" class="form-control" id="title1" name="title1"
                                            placeholder="Enter Title1..." value="{{ old('title1') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="title2">Title2</label>
                                        <input type="text" class="form-control" id="title2" name="title2"
                                            placeholder="Enter Title2..." value="{{ old('title2') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="title3">Title3</label>
                                        <input type="text" class="form-control" id="title3" name="title3"
                                            placeholder="Enter Title3..." value="{{ old('title3') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="title4">Title4</label>
                                        <input type="text" class="form-control" id="title4" name="title4"
                                            placeholder="Enter Title4..." value="{{ old('title4') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="title5">Title5</label>
                                        <input type="text" class="form-control" id="title5" name="title5"
                                            placeholder="Enter Title5..." value="{{ old('title5') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="title6">Title6</label>
                                        <input type="text" class="form-control" id="title6" name="title6"
                                            placeholder="Enter Title6..." value="{{ old('title6') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="title7">Title7</label>
                                        <input type="text" class="form-control" id="title7" name="title7"
                                            placeholder="Enter Title7..." value="{{ old('title7') }}">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="color">Color</label>
                                        <select class="form-control select2bs4" name="color">
                                            <option value="" hidden>---Select---</option>
                                            <option value="black" @if (old('color') == 'black') selected @endif>Black
                                            </option>
                                            <option value="white" @if (old('color') == 'white') selected @endif>
                                                White
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="status">Status</label>
                                        <select class="form-control select2bs4" name="status" name="status">
                                            <option value="" hidden>---Select---</option>
                                            <option value="1" @if (old('status') == '1') selected @endif>Active
                                            </option>
                                            <option value="0" @if (old('status') == '0') selected @endif>
                                                Inactive
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                {{-- <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="description">Descraption</label>
                                        <textarea class="form-control" id="description" name="description" placeholder="Enter description here" rows="5"
                                            cols="5">{{ old('description') }}</textarea>
                                    </div>
                                </div> --}}

                            </div>
                        </div>
                        <div class="card-footer d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary">Create</button>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </div>

    @push('scripts')
        <script type="text/javascript">
            $(document).ready(function() {

                $('.select2bs4').select2({
                    theme: 'bootstrap4'
                })

            });
        </script>
    @endpush
@endsection
