@extends('backend.layouts.main')
@section('title', 'Create')
@section('sections')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Create</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('backend.discountProduct.index') }}">Price Adjustment</a>
                            </li>
                            <li class="breadcrumb-item active">Create</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col">
                        @include('backend.common.message')
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <a class="btn btn-sm btn-secondary" href="{{ route('backend.discountProduct.index') }}">
                            <i class="fa fa-arrow-left" aria-hidden="true"></i>
                        </a>
                    </div>
                    <form action="{{ route('backend.discountProduct.store') }}" method="POST" autocomplete="off"
                        enctype="multipart/form-data">
                        @csrf
                        @method('POST')
                        <div class="card-body">

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="category">Category</label>
                                        <select class="form-control select2bs4" name="category"
                                            onchange="getMasterColors(this.value)">
                                            <option value="" hidden>---Select---</option>
                                            @if (!empty($categories))
                                                @foreach ($categories as $category)
                                                    <option value="{{ $category->id }}"
                                                        @if (old('category') == $category->id) selected @endif>
                                                        {{ $category->name }}
                                                    </option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group" id="masterColor_div">
                                        {{--  --}}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group" id="color_div">
                                        {{--  --}}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="tag_id">Tag</label>
                                        <select class="form-control select2bs4" name="tag_id">
                                            <option value="" hidden>---Select---</option>
                                            @if (!empty($tags))
                                                @foreach ($tags as $tag)
                                                    <option value="{{ $tag->id }}"
                                                        @if (old('tag_id') == $tag->id) selected @endif>
                                                        {{ $tag->name }}
                                                    </option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="product_combination_id">Product Combination</label>
                                        <select class="form-control select2bs4" name="product_combination_id">
                                            <option value="" hidden>---Select---</option>
                                            @if (!empty($productCombinations))
                                                @foreach ($productCombinations as $productCombination)
                                                    <option value="{{ $productCombination->id }}"
                                                        @if (old('product_combination_id') == $productCombination->id) selected @endif>
                                                        {{ $productCombination->name }}
                                                    </option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="product_type_id">Product Type</label>
                                        <select class="form-control select2bs4" name="product_type_id">
                                            <option value="" hidden>---Select---</option>
                                            @if (!empty($productTypes))
                                                @foreach ($productTypes as $productType)
                                                    <option value="{{ $productType->id }}"
                                                        @if (old('product_type_id') == $productType->id) selected @endif>
                                                        {{ $productType->name }}
                                                    </option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="discount">Discount</label>
                                        <select class="form-control select2bs4" name="discount">
                                            <option value="" hidden>---Select---</option>
                                            <option value="1" @if (old('discount') == '1') selected @endif>
                                                Increase
                                            </option>
                                            <option value="2" @if (old('discount') == '2') selected @endif>
                                                Decrease
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="type">type</label>
                                        <select class="form-control select2bs4" name="type">
                                            <option value="" hidden>---Select---</option>
                                            <option value="1" @if (old('type') == '1') selected @endif>
                                                Percentage
                                            </option>
                                            <option value="2" @if (old('type') == '2') selected @endif>
                                                Amount
                                            </option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="dis_amount">Discount Amount</label>
                                        <input type="number" class="form-control" id="dis_amount" name="dis_amount"
                                            placeholder="Enter Discount Amount here" value="{{ old('dis_amount') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="status">Status</label>
                                        <select class="form-control select2bs4" name="status">
                                            <option value="" hidden>---Select---</option>
                                            <option value="1" @if (old('status') == '1') selected @endif>
                                                Active
                                            </option>
                                            <option value="0" @if (old('status') == '0') selected @endif>
                                                Inactive
                                            </option>
                                        </select>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="card-footer d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary">Create</button>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </div>

    @push('scripts')
        <script type="text/javascript">
            $(document).ready(function() {
                $('#summernote').summernote()
                $('.select2bs4').select2({
                    theme: 'bootstrap4'
                })

            });

            function getMasterColors(category) {
                $.ajax({
                    url: "{{ route('backend.get.masterColors') }}",
                    type: "post",
                    data: {
                        _token: '{{ csrf_token() }}',
                        category
                    },
                    success: function(response) {
                        console.log(response);
                        if (response.status == 'success') {
                            let html = `<label for="masterColor_id">Master Color</label>
                                        <select class="form-control select2bs4" onchange="getColors(this.value)" name="masterColor_id">
                                            <option value="" hidden>---Select---</option>`;
                            response.data.forEach((master) => {
                                html += `<option value="${master.id}">${master.name}</option>`;
                            })
                            html += `</select>`;

                            $("#masterColor_div").html(html);
                            $('.select2bs4').select2({
                                theme: 'bootstrap4'
                            })
                        }
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    }
                });
            }

            function getColors(colorMaster) {
                $.ajax({
                    url: "{{ route('backend.get.colors') }}",
                    type: "post",
                    data: {
                        _token: '{{ csrf_token() }}',
                        colorMaster
                    },
                    success: function(response) {
                        console.log(response);
                        if (response.status == 'success') {
                            let html = `<label for="color_id">Color</label>
                        <select class="form-control select2bs4" name="color_id">
                            <option value="" hidden>---Select---</option>`;
                            response.data.forEach((color) => {
                                html += `<option value="${color.id}">${color.name}</option>`;
                            })
                            html += `</select>`;

                            $("#color_div").html(html);
                            $('.select2bs4').select2({
                                theme: 'bootstrap4'
                            })
                        }
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    }
                });
            }
        </script>
    @endpush
@endsection
