@extends('backend.layouts.main')
@section('title', 'Edit')
@section('sections')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Edit</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('backend.discountProduct.index') }}">Price Adjustment</a>
                            </li>
                            <li class="breadcrumb-item active">Edit</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col">
                        @include('backend.common.message')
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <a class="btn btn-sm btn-secondary" href="{{ route('backend.discountProduct.index') }}">
                            <i class="fa fa-arrow-left" aria-hidden="true"></i>
                        </a>
                    </div>
                    <form action="{{ route('backend.discountProduct.update', $discountProduct) }}" method="POST"
                        autocomplete="off" enctype="multipart/form-data">
                        @csrf
                        @method('put')
                        <div class="card-body">

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="product_id">Category</label>
                                        <input class="form-control" value="{{ $category_name->name }}" readonly>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="color_id">Color Master</label>
                                        <input class="form-control" value="{{ $master_name->name }}" readonly>

                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="color_id">Color</label>
                                        <input class="form-control" value="{{ $color_name->name }}" readonly>

                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="color_id">Product Combination</label>
                                        <input class="form-control" value="{{ $ProductCombination_name->name ?? null }}"
                                            readonly>

                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="color_id">Product Type</label>
                                        <input class="form-control" value="{{ $productType_name->name }}" readonly>

                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="tag_id">Tag</label>
                                        <input class="form-control" value="{{ $tag_name->name }}" readonly>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="discount">Discount</label>
                                        <select class="form-control select2bs4" name="discount">
                                            <option value="" hidden>---Select---</option>
                                            <option value="1" @if ($discountProduct->discount == '1') selected @endif>
                                                Increase
                                            </option>
                                            <option value="2" @if ($discountProduct->discount == '2') selected @endif>
                                                Decrease
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="type">Type</label>
                                        <select class="form-control select2bs4" name="type">
                                            <option value="" hidden>---Select---</option>
                                            <option value="1" @if ($discountProduct->type == '1') selected @endif>
                                                Percentage
                                            </option>
                                            <option value="2" @if ($discountProduct->type == '2') selected @endif>
                                                Amount
                                            </option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="dis_amount">Discount Amount</label>
                                        <input type="number" class="form-control" id="dis_amount" name="dis_amount"
                                            placeholder="Enter Discount Amount here"
                                            value="{{ $discountProduct->dis_amount }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="status">Status</label>
                                        <select class="form-control select2bs4" name="status">
                                            <option value="" hidden>---Select---</option>
                                            <option value="1" @if ($discountProduct->status == '1') selected @endif>
                                                Active
                                            </option>
                                            <option value="0" @if ($discountProduct->status == '0') selected @endif>
                                                Inactive
                                            </option>
                                        </select>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="card-footer d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </div>

    @push('scripts')
        <script type="text/javascript">
            $(document).ready(function() {
                $('#summernote').summernote()
                $('.select2bs4').select2({
                    theme: 'bootstrap4'
                })

            });
        </script>
    @endpush
@endsection
