@extends('backend.layouts.main')
@section('title', 'Create')
@section('sections')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Create</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('backend.freeDesignContent.index') }}">Free Design
                                    Content</a>
                            </li>
                            <li class="breadcrumb-item active">Create</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col">
                        @include('backend.common.message')
                    </div>
                </div>

                <div class="card">
                    <form action="{{ route('backend.freeDesignContent.store') }}" method="POST" autocomplete="off"
                        enctype="multipart/form-data">
                        @csrf
                        @method('POST')
                        <div class="card-body">

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="image">Image</label>
                                        <input type="file" class="form-control" id="image" name="image"
                                            class="type-1">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="title_one">Title one</label>
                                        <input type="text" class="form-control" id="title_one" name="title_one"
                                            placeholder="Enter Title one..." value="{{ old('title_one') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="title_two">Title two</label>
                                        <input type="text" class="form-control" id="title_two" name="title_two"
                                            placeholder="Enter Title two..." value="{{ old('title_two') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="title_three">Title three</label>
                                        <input type="text" class="form-control" id="title_three" name="title_three"
                                            placeholder="Enter Title three..." value="{{ old('title_three') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="title_four">Title four</label>
                                        <input type="text" class="form-control" id="title_four" name="title_four"
                                            placeholder="Enter Title four..." value="{{ old('title_four') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="title_five">Title five</label>
                                        <input type="text" class="form-control" id="title_five" name="title_five"
                                            placeholder="Enter Title five..." value="{{ old('title_five') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="button_url_one">Button url one</label>
                                        <input type="text" class="form-control" id="button_url_one" name="button_url_one"
                                            placeholder="Enter button url one..." value="{{ old('button_url_one') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="button_url_two">Button url two</label>
                                        <input type="text" class="form-control" id="button_url_two" name="button_url_two"
                                            placeholder="Enter button url two..." value="{{ old('button_url_two') }}">
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="description_one">Descraption one</label>
                                        <textarea class="form-control" id="summernote" name="description_one" placeholder="Enter description one here"
                                            rows="5" cols="5">{{ old('description_one') }}</textarea>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="description_two">Descraption two</label>
                                        <textarea class="form-control" id="description_two" name="description_two" placeholder="Enter description two here"
                                            rows="5" cols="5">{{ old('description_two') }}</textarea>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="description_three">Descraption three</label>
                                        <textarea class="form-control" id="description_three" name="description_three"
                                            placeholder="Enter description three here" rows="5" cols="5">{{ old('description_three') }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary">Create</button>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </div>

    @push('scripts')
        <script type="text/javascript">
            $(document).ready(function() {
                $('#summernote').summernote()
                $('.select2').select2()
            });
            bootstrap4
        </script>
    @endpush
@endsection
