@extends('backend.layouts.main')
@section('title', 'Edit')
@section('sections')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Edit</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('backend.gallery.index') }}">Gallery</a>
                            </li>
                            <li class="breadcrumb-item active">Edit</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col">
                        @include('backend.common.message')
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <a class="btn btn-sm btn-secondary" href="{{ route('backend.gallery.index') }}">
                            <i class="fa fa-arrow-left" aria-hidden="true"></i>
                        </a>
                    </div>
                    <form action="{{ route('backend.gallery.update', $gallery) }}" method="POST" autocomplete="off"
                        enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="image">Preview Image</label>
                                        <img src="{{ asset($gallery->image) }}" class="type-1">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Type</label>
                                        <select class="form-control select2bs4" name="type"
                                            onchange="getType(this.value)">
                                            <option value="" hidden>---Select---</option>
                                            <option value="1" @if ($gallery->type == '1') selected @endif>
                                                Category</option>
                                            <option value="2" @if ($gallery->type == '2') selected @endif>Our
                                                Service</option>
                                        </select>
                                    </div>

                                </div>
                                <div class="col-md-6" id="ourservisesmaster_div">
                                    <div class="form-group">
                                        <label>Our Service</label>
                                        <select class="form-control select2bs4" name="ourservisesmaster_id">
                                            <option value="" hidden>---Select---</option>
                                            @if (!empty($OurServisesMasters))
                                                @foreach ($OurServisesMasters as $OurServisesMaster)
                                                    <option value="{{ $OurServisesMaster->id }}"
                                                        @if ($OurServisesMaster->id == $gallery->ourservisesmaster_id) selected @endif>
                                                        {{ $OurServisesMaster->name }}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>

                                </div>
                                <div class="col-md-6" id="type_div">
                                    <div class="form-group">
                                        <label>Type</label>
                                        <select class="form-control select2bs4" name="type_id">
                                            <option value="" hidden>---Select---</option>
                                            @if (!empty($types))
                                                @foreach ($types as $type)
                                                    <option value="{{ $type->id }}"
                                                        @if ($type->id == $gallery->type_id) selected @endif>
                                                        {{ $type->name }}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>

                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="image">Image</label>
                                        <input type="file" class="form-control" id="image" name="image"
                                            class="type-1">
                                    </div>
                                </div>


                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="status">Status</label>
                                        <select class="form-control select2bs4" name="status">
                                            <option value="" hidden>---Select---</option>
                                            <option value="1" @if ($gallery->status == '1') selected @endif>Active
                                            </option>
                                            <option value="0" @if ($gallery->status == '0') selected @endif>
                                                Inactive
                                            </option>
                                        </select>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="card-footer d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </div>

    @push('scripts')
        <script type="text/javascript">
            $(document).ready(function() {
                $('.select2').select2();
                getType({{ $gallery->type }});
            });

            function getType(type) {
                if (type == 1) {
                    $("#ourservisesmaster_div").hide();
                    $("#type_div").show();
                } else {
                    $("#ourservisesmaster_div").show();
                    $("#type_div").hide();
                }
            }
        </script>
    @endpush
@endsection
