@extends('backend.layouts.main')
@section('title', 'Edit')
@section('sections')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Edit</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('backend.assemblyInstruction.index') }}">Assembly
                                    Isntruction</a>
                            </li>
                            <li class="breadcrumb-item active">Edit</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col">
                        @include('backend.common.message')
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <a class="btn btn-sm btn-secondary" href="{{ route('backend.assemblyInstruction.index') }}">
                            <i class="fa fa-arrow-left" aria-hidden="true"></i>
                        </a>
                    </div>
                    <form action="{{ route('backend.kitchen.design.tool.update') }}" method="POST" autocomplete="off"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="card-body">

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="image">Preview Image 1 :</label> <img
                                            src="{{ asset($assemblyIsntructions->image_one ?? null) }}" class="type-1">

                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="image">Preview Image 2 :</label><img
                                            src="{{ asset($assemblyIsntructions->image_two ?? null) }}" class="type-1">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="image1">Image 1</label>
                                        <input type="file" class="form-control" id="image1" name="image1"
                                            class="type-1">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="image2">Image 2</label>
                                        <input type="file" class="form-control" id="image2" name="image2"
                                            class="type-1">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="title">Title One</label>
                                        <input type="text" class="form-control" id="title" name="title"
                                            value="{{ $assemblyIsntructions->title_one ?? null }}">
                                    </div>
                                </div>
                                <div class="col-md-6"></div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="title">Title Two </label>
                                        <input type="text" class="form-control" id="title_two" name="title_two"
                                            value="{{ $assemblyIsntructions->title_two ?? null }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="shot_description">Description Two</label>
                                        <input type="text" class="form-control" id="shot_description"
                                            name="shot_description"
                                            value="{{ $assemblyIsntructions->description_two ?? null }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="title">URL </label>
                                        <input type="text" class="form-control" id="button_url" name="button_url"
                                            value="{{ $assemblyIsntructions->button_url ?? null }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="title">Title Three </label>
                                        <input type="text" class="form-control" id="title_three" name="title_three"
                                            value="{{ $assemblyIsntructions->title_three ?? null }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="shot_description">Description Three</label>
                                        <input type="text" class="form-control" id="description_three"
                                            name="description_three"
                                            value="{{ $assemblyIsntructions->description_three ?? null }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="shot_description">Contact No</label>
                                        <input type="text" class="form-control" id="contact_number"
                                            name="contact_number"
                                            value="{{ $assemblyIsntructions->contact_number ?? null }}">
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="card-footer d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </div>

    @push('scripts')
        <script type="text/javascript">
            $(document).ready(function() {
                $('#summernote').summernote()
                $('.select2bs4').select2({
                    theme: 'bootstrap4'
                })

            });
        </script>
    @endpush
@endsection
