@extends('backend.layouts.main')
@section('title', 'Create')
@section('sections')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Create</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('backend.pricingTitle.index') }}">Pricing
                                    Title</a>
                            </li>
                            <li class="breadcrumb-item active">Create</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col">
                        @include('backend.common.message')
                    </div>
                </div>

                <div class="card">
                    <form action="{{ route('backend.pricingTitle.store') }}" method="POST" autocomplete="off"
                        enctype="multipart/form-data">
                        @csrf
                        @method('POST')
                        <div class="card-body">

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="title_one">Title one</label>
                                        <input type="text" class="form-control" id="title_one" name="title_one"
                                            placeholder="Enter Title one..." value="{{ old('title_one') }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="title_two">Title two</label>
                                        <input type="text" class="form-control" id="title_two" name="title_two"
                                            placeholder="Enter Title two..." value="{{ old('title_two') }}">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="description_one">Descraption</label>
                                        <textarea class="form-control" id="description_one" name="description_one" placeholder="Enter description one here"
                                            rows="5" cols="5">{{ old('description_one') }}</textarea>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="card-footer d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary">Create</button>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </div>

    @push('scripts')
        <script type="text/javascript">
            $(document).ready(function() {
                $('#summernote').summernote()
                $('.select2').select2()
            });
            bootstrap4
        </script>
    @endpush
@endsection
