@extends('backend.layouts.main')
@section('title', 'Combinations')
@section('sections')

    <link rel="stylesheet" href="{{ asset('frontend/css/toastr.css') }}" />
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Combinations</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('backend.product.index') }}">Product</a>
                            </li>
                            <li class="breadcrumb-item active">Combinations</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col">
                        @include('backend.common.message')
                    </div>
                </div>
                <div class="card" style="padding: 20px 10px;">
                    <form action="{{ route('backend.productCombination.import') }}" method="POST" autocomplete="off"
                        enctype="multipart/form-data">
                        @csrf
                        @method('POST')
                        <div class="row">
                            <input type="hidden" name="product_id" value="{{ $product }}">
                            <div class="col-md-3">
                                <input type="file" class="form-control" name="csv" class="type-1">
                            </div>
                            <div class="col-md-3">
                                <button type="submit" class="btn btn-outline-primary w-100">
                                    <i class="fa fa-upload" aria-hidden="true"></i>
                                    Upload Combinations
                                </button>
                            </div>
                            <div class="col-md-3">
                                <a download="Combination" href="{{ asset('productCSV/combination.csv') }}"
                                    title="Combination"><button type="button" class="btn btn-outline-info  w-100">
                                        <i class="fa fa-download" aria-hidden="true"></i>
                                        Download Sample
                                    </button></a>
                            </div>
                            <div class="col-md-3">
                                <button type="button" class="btn btn-outline-dark w-100" onclick="exportData()">
                                    <i class="fa fa-download" aria-hidden="true"></i>
                                    Download Combinations
                                </button>
                            </div>
                        </div>
                    </form>
                </div>


                <div class="card">
                    <div class="card-header">
                        <div class="btn-1">
                            <a class="btn btn-sm btn-secondary" href="{{ route('backend.product.index') }}">
                                <i class="fa fa-arrow-left" aria-hidden="true"></i>
                            </a>
                        </div>
                    </div>

                    <form action="{{ route('backend.productCombination.store') }}" method="POST" autocomplete="off"
                        enctype="multipart/form-data">
                        @csrf
                        @method('POST')
                        <div class="card-body" id="card_body">

                            <div class="row">
                                <input type="hidden" name="product_id" value="{{ $product }}">
                                <table id="myTable" class="text-center">
                                    <tr>
                                        <th>SKU</th>
                                        <th>Description</th>
                                        <th>Tag</th>
                                        <th>Product Type</th>
                                        <th>Main price</th>
                                        <th>Discount price</th>
                                        {{-- <th>Color</th> --}}
                                        <th>In stock</th>
                                        {{--                                        <th>Image</th> --}}
                                        <th>Status
                                        <th>Action</th>
                                    </tr>
                                    @if (!empty($combinitions))
                                        @foreach ($combinitions as $combinition)
                                            <tr>

                                                <td>
                                                    <input type="text" class="form-control"
                                                        value="{{ $combinition->name }}" name="name_{{ $combinition->id }}"
                                                        id="name_{{ $combinition->id }}">
                                                </td>
                                                <td>
                                                    <input type="text" class="form-control"
                                                        name="dimension_{{ $combinition->id }}" class="type-1"
                                                        value="{{ $combinition->dimension }}"
                                                        id="dimension_{{ $combinition->id }}">
                                                </td>
                                                <td>
                                                    <select class="form-control select2bs4"
                                                        name="tag_id_{{ $combinition->id }}"
                                                        id="tag_id_{{ $combinition->id }}">
                                                        <option value="" hidden>Select tag</option>
                                                        @if (count($tags) > 0)
                                                            @foreach ($tags as $tag)
                                                                <option value="{{ $tag->id }}"
                                                                    @if ($combinition->tag_id == $tag->id) selected @endif>
                                                                    {{ $tag->name }}
                                                                </option>
                                                            @endforeach
                                                        @endif
                                                    </select>
                                                </td>
                                                <td>
                                                    <select class="form-control select2bs4"
                                                        name="product_type_id_{{ $combinition->id }}"
                                                        id="product_type_id_{{ $combinition->id }}">
                                                        <option value="" hidden>Select product type</option>
                                                        @if (count($productTypes) > 0)
                                                            @foreach ($productTypes as $productType)
                                                                <option value="{{ $productType->id }}"
                                                                    @if ($combinition->product_type_id == $productType->id) selected @endif>
                                                                    {{ $productType->name }}
                                                                </option>
                                                            @endforeach
                                                        @endif
                                                    </select>
                                                </td>
                                                <td>
                                                    <input type="text" {{-- onkeypress='return event.charCode >= 48 && event.charCode <= 57' --}} class="form-control"
                                                        value="{{ $combinition->main_price }}"
                                                        name="main_price_{{ $combinition->id }}"
                                                        id="main_price_{{ $combinition->id }}">
                                                </td>
                                                <td>
                                                    <input type="text" {{-- onkeypress='return event.charCode >= 48 && event.charCode <= 57' --}} class="form-control"
                                                        value="{{ $combinition->discount_price }}"
                                                        name="discount_price_{{ $combinition->id }}"
                                                        id="discount_price_{{ $combinition->id }}">
                                                </td>

                                                {{-- <td>
                                                    <select class="form-control select2bs4"
                                                        name="color_id_{{ $combinition->id }}">
                                                        <option value="" hidden>Select color</option>
                                                        @if (count($colors) > 0)
                                                            @foreach ($colors as $color)
                                                                <option value="{{ $color->id }}"
                                                                    @if ($combinition->color_id == $color->id) selected @endif>
                                                                    {{ $color->name }}
                                                                </option>
                                                            @endforeach
                                                        @endif
                                                    </select>
                                                </td> --}}
                                                <td>
                                                    <select class="form-control select2bs4"
                                                        name="in_stock_{{ $combinition->id }}"
                                                        id="in_stock_{{ $combinition->id }}">
                                                        <option value="1"
                                                            @if ($combinition->in_stock == '1') selected @endif>
                                                            Yes
                                                        </option>
                                                        <option value="0"
                                                            @if ($combinition->in_stock == '0') selected @endif>
                                                            No
                                                        </option>
                                                    </select>
                                                </td>
                                                {{--                                                <td> --}}
                                                {{--                                                    <img src="{{ asset($combinition->image) }}" --}}
                                                {{--                                                        style="width: 50px;height: 50px"> --}}
                                                {{--                                                    <input type="file" class="form-control" --}}
                                                {{--                                                        name="images_{{ $combinition->id }}" class="type-1" --}}
                                                {{--                                                        id="images_{{ $combinition->id }}" --}}
                                                {{--                                                        onchange="convertBase64({{ $combinition->id }})"> --}}
                                                {{--                                                    <input type="text" class="form-control" --}}
                                                {{--                                                        value="{{ $combinition->image }}" disabled> --}}
                                                {{--                                                </td> --}}
                                                <td>
                                                    <select class="form-control select2bs4"
                                                        name="status_{{ $combinition->id }}"
                                                        id="status_{{ $combinition->id }}">
                                                        <option value="1"
                                                            @if ($combinition->status == '1') selected @endif>
                                                            Active
                                                        </option>
                                                        <option value="0"
                                                            @if ($combinition->status == '0') selected @endif>
                                                            Inactive
                                                        </option>
                                                    </select>
                                                </td>
                                                <td>
                                                    <a
                                                        href="{{ route('backend.productCombination.delete', $combinition->id) }}">
                                                        <button type="button" class="btn btn-danger btn-sm">
                                                            <i class="fa fa-trash" aria-hidden="true"></i>
                                                        </button>

                                                    </a>
                                                    <button type="button" class="btn btn-success btn-sm"
                                                        style="margin-top: 10px;"
                                                        onclick="updateFunction({{ $combinition->id }})">
                                                        <i class="fa fa-pencil-square-o" aria-hidden="true"></i>

                                                    </button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                    @include('backend.master.product.combination.row')

                                </table>
                            </div>
                            {{ $combinitions->links() }}
                        </div>
                        <div class="card-footer d-flex justify-content-end">
                            <button type="submit" class="btn btn-success" style="    margin-right: 10px;">Update
                                All</button>
                            <a href="{{ route('backend.productCombination.delete_all', $product) }}"
                                class="btn btn-danger">Delete All </a>

                        </div>

                    </form>
                </div>
            </div>
        </section>
    </div>

    @push('scripts')
        <script src="{{ asset('frontend/js/toastr.js') }}"></script>
        <script type="text/javascript">
            var x = 0;
            $(document).ready(function() {

                $('.select2bs4').select2({
                    theme: 'bootstrap4'
                })

            });


            function deleteRow(rowid) {
                $("#tr_input_" + rowid).empty();
            }

            // function addRow(rowid) {
            //     $("#tr_input_" + rowid).insertRow(rowid);
            // }

            function exportData() {
                var product_id = {{ $product }};
                let route = "{{ route('backend.productCombination.export') }}";

                route = route + '?product_id=' + product_id;


                var xhr = new XMLHttpRequest();
                xhr.open('GET', route);
                xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
                xhr.onreadystatechange = function() {
                    if (xhr.readyState === XMLHttpRequest.DONE) {
                        if (xhr.status === 200) {
                            var blob = new Blob([xhr.response]);
                            var link = document.createElement('a');
                            link.href = window.URL.createObjectURL(blob);
                            link.download = 'Combination.csv';
                            link.click();
                        } else {
                            console.error('Export failed');
                        }
                    }
                };

                xhr.responseType = 'blob';
                xhr.send();
            }
            let image;

            const convertBase64 = (combinition) => {
                var inputElement = document.getElementById('images_' + combinition);
                if (inputElement.files && inputElement.files[0]) {
                    var file = inputElement.files[0];
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        image = e.target.result;
                    };
                    reader.readAsDataURL(file);
                }
            }

            const updateFunction = (combinition) => {
                let name = document.getElementById('name_' + combinition).value;

                let dimension = document.getElementById('dimension_' + combinition).value;
                let tag_id = document.getElementById('tag_id_' + combinition).value;
                let product_type_id = document.getElementById('product_type_id_' + combinition).value;
                let main_price = document.getElementById('main_price_' + combinition).value;
                let discount_price = document.getElementById('discount_price_' + combinition).value;
                let in_stock = document.getElementById('in_stock_' + combinition).value;
                let status = document.getElementById('status_' + combinition).value;

                $.ajax({
                    url: "{{ route('backend.productCombination.update') }}",
                    type: "post",
                    data: {
                        _token: '{{ csrf_token() }}',
                        name,
                        dimension,
                        tag_id,
                        product_type_id,
                        main_price,
                        discount_price,
                        in_stock,
                        status,
                        image,
                        combinition
                    },
                    success: function(response) {
                        console.log(response);
                        if (response.status == 'success') {
                            toastr.success(response.msg, 'Success!');
                            setTimeout(() => {
                                location.reload();
                            }, 2000);
                        } else {
                            toastr.error(response.msg, 'Warning!');
                        }
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    }
                });
            };
        </script>
    @endpush
@endsection
