@extends('backend.layouts.main')
@section('title', 'Create')
@section('sections')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Create</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('backend.product.index') }}">Product</a>
                            </li>
                            <li class="breadcrumb-item active">Create</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col">
                        @include('backend.common.message')
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <a class="btn btn-sm btn-secondary" href="{{ route('backend.product.index') }}">
                            <i class="fa fa-arrow-left" aria-hidden="true"></i>
                        </a>
                    </div>
                    <form action="{{ route('backend.product.store') }}" method="POST" autocomplete="off"
                        enctype="multipart/form-data">
                        @csrf
                        @method('POST')
                        <div class="card-body">

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="category">Category</label>
                                        <select class="form-control select2bs4" name="category" id='type'>
                                            <option value="" hidden>---Select---</option>
                                            @if (count($categories) != 0)
                                                @foreach ($categories as $category)
                                                    <option value="{{ $category->id }}"
                                                        @if (old('category') == $category->id) selected @endif>
                                                        {{ $category->name }}
                                                    </option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>

                                {{-- <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="video_link">Video link</label>
                                        <input type="link" class="form-control" value="{{ old('video_link') }}"
                                            name="video_link" class="type-1">
                                    </div>
                                </div> --}}
                                {{-- <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="model_number">Model number</label>
                                        <input type="text" class="form-control" id="model_number" name="model_number"
                                            value="{{ old('model_number') }}">
                                    </div>
                                </div> --}}

                                <div class="col-md-6 row-acc">
                                    <div class="form-group">
                                        <label for="name">Name</label>
                                        <input type="text" class="form-control" id="name" name="name"
                                            value="{{ old('name') }}">
                                    </div>
                                </div>
                                <div class="col-md-6 row-acc">
                                    <div class="form-group">
                                        <label for="main_price">Main price</label>
                                        <input type="text" class="form-control" id="main_price" name="main_price"
                                            value="{{ old('main_price') }}">
                                    </div>
                                </div>
                                <div class="col-md-6 row-acc">
                                    <div class="form-group">
                                        <label for="discount_price">Discount price</label>
                                        <input type="text" class="form-control" id="discount_price" name="discount_price"
                                            value="{{ old('discount_price') }}">
                                    </div>
                                </div>
                                <div class="col-md-6 row-acc">
                                    <div class="form-group">
                                        <label>Sort Order</label>
                                        <select class="form-control" name="sort_order2">
                                            <option value="" selected hidden>Select sort order</option>
                                            @if (!empty($sort_order2))
                                                @for ($i = 1; $i <= $sort_order2; $i++)
                                                    <option value="{{ $i }}" selected>
                                                        {{ $i }}</option>
                                                @endfor
                                            @endif
                                        </select>
                                    </div>
                                </div>

                                {{-- <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="cabinet_id">Cabinet</label>
                                        <select class="form-control select2bs4" name="cabinet_id">
                                            <option value="" hidden>---Select---</option>
                                            @if (count($cabinets) != 0)
                                                @foreach ($cabinets as $cabinet)
                                                    <option value="{{ $cabinet->id }}"
                                                        @if (old('cabinet_id') == $cabinet->id) selected @endif>
                                                        {{ $cabinet->name }}
                                                    </option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div> --}}
                                {{-- <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="construction_type">Constructions Type</label>
                                        <select class="form-control select2bs4" name="construction_type">
                                            <option value="" hidden>---Select---</option>
                                            @if (count($constructions) != 0)
                                                @foreach ($constructions as $construction)
                                                    <option value="{{ $construction->id }}"
                                                        @if (old('construction_type') == $construction->id) selected @endif>
                                                        {{ $construction->title }}
                                                    </option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div> --}}
                                <div class="col-md-6 row-dim">
                                    <div class="form-group">
                                        <label for="background_image">Background Image</label>
                                        <input type="file" class="form-control" id="background_image"
                                            name="background_image" class="type-1">
                                    </div>
                                </div>
                                <div class="col-md-6 row-dim">
                                    <div class="form-group">
                                        <label for="colorMaster_id">Color Master</label>
                                        <select class="form-control select2bs4" name="colorMaster_id"
                                            onchange="getColors(this.value)">
                                            <option value="">Select Color Master</option>
                                            @if (count($colors) != 0)
                                                @foreach ($colors as $color)
                                                    <option value="{{ $color->id }}">
                                                        {{ $color->name }}
                                                    </option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6 row-dim">
                                    <div class="form-group" id="append_color">

                                    </div>
                                </div>
                                <div class="col-md-6 row-dim">
                                    <div class="form-group">
                                        <label>Sort Order</label>
                                        <select class="form-control" name="sort_order1">
                                            <option value="" selected hidden>Select sort order</option>
                                            @if (!empty($sort_order1))
                                                @for ($i = 1; $i <= $sort_order1; $i++)
                                                    <option value="{{ $i }}" selected>
                                                        {{ $i }}</option>
                                                @endfor
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="status">Status</label>
                                        <select class="form-control select2bs4" name="status">
                                            <option value="" hidden>---Select---</option>
                                            <option value="1" @if (old('status') == '1') selected @endif>
                                                Active
                                            </option>
                                            <option value="0" @if (old('status') == '0') selected @endif>
                                                Inactive
                                            </option>
                                        </select>
                                    </div>
                                </div>

                                {{-- <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="information">Information</label>
                                        <textarea class="form-control" id="information" name="information" placeholder="Enter information here"
                                            rows="5" cols="5">{{ old('information') }}</textarea>
                                    </div>
                                </div> --}}
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="description">Descraption</label>
                                        <textarea class="form-control" id="summernote" name="description" placeholder="Enter description here"
                                            rows="5" cols="5">{{ old('description') }}</textarea>
                                    </div>
                                </div>
                                <div class="col-md-12 row-acc">
                                    <div class="form-group">
                                        <label for="measurements">Measurements</label>
                                        <textarea class="form-control" id="measurements" name="measurements" placeholder="Enter measurements here"
                                            rows="5" cols="5">{{ old('measurements') }}</textarea>
                                    </div>
                                </div>
                                <div class="col-md-12 row-acc">
                                    <div class="form-group">
                                        <label for="key_features">Key Features</label>
                                        <textarea class="form-control" id="key_features" name="key_features" placeholder="Enter key features here"
                                            rows="5" cols="5">{{ old('key_features') }}</textarea>
                                    </div>
                                </div>
                                <div class="col-md-12 row-acc">
                                    <div class="form-group">
                                        <label for="return_policies">Return Policies</label>
                                        <textarea class="form-control" id="return_policies" name="return_policies" placeholder="Enter return policies here"
                                            rows="5" cols="5">{{ old('return_policies') }}</textarea>
                                    </div>
                                </div>
                                {{-- <div class="col-md-12">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="exampleCheck1"
                                            name="quick_shipping" value="1">
                                        <label class="form-check-label" for="exampleCheck1">Quick Shipping</label>
                                    </div>
                                </div> --}}
                            </div>
                        </div>
                        <div class="card-footer d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary">Create</button>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </div>

    @push('scripts')
        <script type="text/javascript">
            $(document).ready(function() {
                $('#summernote').summernote()

                $('.select2bs4').select2({
                    theme: 'bootstrap4'
                })

            });

            function getColors(master_color_id) {
                $.ajax({
                    url: "{{ route('backend.all.get.colors') }}",
                    type: "post",
                    data: {
                        _token: '{{ csrf_token() }}',
                        master_color_id
                    },
                    success: function(response) {
                        $("#append_color").html(response.html);
                        $('.select2bs4').select2({
                            theme: 'bootstrap4'
                        })
                        console.log(response)
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    }
                });
            }
            $(function() {
                $('.row-dim').hide();
                $('.row-acc').hide();
                $('#type').change(function() {
                    if ($('#type').val() == 1) {
                        $('.row-dim').show();
                        $('.row-acc').hide();
                    } else {
                        $('.row-acc').show();
                        $('.row-dim').hide();
                    }
                });
            });
        </script>
    @endpush
@endsection
