@extends('backend.layouts.main')
@section('title', 'Image')
@section('sections')
    <style>
        form {
            margin: 20px 50px;
            border-radius: 8px;
        }

        .dz-button {
            font-size: 25px !important;
        }
    </style>
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Image</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('backend.product.index') }}">Product</a>
                            </li>
                            <li class="breadcrumb-item active">Image</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        @include('backend.common.message')
                    </div>
                </div>
                <div class="card">
                    <div class="card-header">

                        <div class="btn-1">
                            <a class="btn btn-sm btn-secondary" href="{{ route('backend.product.index') }}">
                                <i class="fa fa-arrow-left" aria-hidden="true"></i>
                            </a>
                        </div>
                        <div class="btn-2 w-100 d-flex justify-content-end">
                            @php
                                $combination = App\Models\Product::where('id', $id)->first();
                            @endphp
                            @if ($combination->category == 1)
                                <a class="btn btn-sm btn-outline-primary"
                                    href="{{ route('backend.productCombination.add', $id) }}">
                                    <i class="fa fa-plus-circle" aria-hidden="true"></i> Combination
                                </a>
                            @else
                                <a class="btn btn-sm btn-outline-primary"
                                    href="{{ route('backend.productCombinationAss.add', $id) }}">
                                    <i class="fa fa-plus-circle" aria-hidden="true"></i> Combination
                                </a>
                            @endif
                        </div>

                    </div>
                    <form action="{{ route('backend.productImage.store') }}" method="post" class="dropzone"
                        id="myDropzone">
                        @csrf
                        <input type="hidden" name="id" value="{{ $id }}">
                    </form>
                </div>


                <div class="card card-outline card-primary">
                    <div class="card-body p-0">
                        <table id="table" class="table m-0">
                            <thead>
                                <tr>
                                    <th>File</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @push('scripts')
        <script>
            var table, Toast;
            $(document).ready(function() {
                table = $('#table').DataTable({
                    dom: '<"pl-2 pt-2 pr-2 pb-2" <"row" <"col-lg-6" l><"col-lg-3" f><"col-lg-3 text-right" B>> > rt <"border-top pl-2 pt-2 pr-2 pb-2 " <"row" <"col-lg-6" i><"col-lg-6" p>> >',
                    buttons: [],
                    lengthChange: false,
                    searching: false,
                    info: true,
                    paging: true,
                    searchHighlight: false,
                    ordering: false,
                    autoWidth: false,
                    responsive: true,
                    processing: true,
                    serverSide: true,
                    stateSave: false,
                    deferRender: true,
                    pageLength: 10,
                    order: false,
                    columnDefs: [{
                            orderable: false,
                            targets: [0, 1]
                        },
                        {
                            className: 'text-center',
                            targets: [0, 1]
                        },
                        {
                            width: '30px',
                            targets: 1
                        }
                    ],
                    ajax: {
                        url: '{{ url()->current() }}',
                        dataType: 'json',
                        type: 'GET',
                        data: function(d) {
                            d.id = '{{ $id }}'
                        }

                    },
                    columns: [{
                        data: 'image'
                    }, {
                        data: 'action'
                    }]
                });

                Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 3000
                });
            });

            Dropzone.options.myDropzone = {
                paramName: "file",
                maxFilesize: 1024, // MB
                timeout: 180000,
                // acceptedFiles: ".pdf",
                addRemoveLinks: true,
                init: function() {
                    this.on("success", function(file, response) {
                        if (response.status == 'success') {
                            Toast.fire({
                                icon: 'success',
                                title: response.msg
                            })
                            table.draw(false);
                            this.removeAllFiles(true);
                        } else {
                            Toast.fire({
                                icon: 'error',
                                title: response.msg
                            })
                        }
                    });
                    this.on("error", function(file, errorMessage) {
                        Toast.fire({
                            icon: 'error',
                            title: errorMessage
                        })
                    });
                }
            };
        </script>
    @endpush
@endsection
