@extends('backend.layouts.main')
@section('title', 'Product')
@section('sections')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4 class="m-0 text-dark">Product</h4>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">Product</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col">
                        @include('backend.common.message')
                    </div>
                </div>


                <div class="card card-outline card-primary">
                    <div class="card-body p-0">
                        <table id="table" class="table m-0">
                            <thead>
                                <tr>
                                    <th>Background Image</th>
                                    <th>Image</th>
                                    <th>Name</th>
                                    {{-- <th>Cabinet</th> --}}
                                    {{-- <th>Model Number</th> --}}
                                    <th>Category</th>
                                    <th>Color Master</th>
                                    <th>Color</th>
                                    {{-- <th>Color</th> --}}
                                    {{-- <th>Door Style</th> --}}
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @push('scripts')
        <script type="text/javascript">
            $(document).ready(function() {

                $('.select2bs4').select2({
                    theme: 'bootstrap4'
                })

                var table = $('#table').DataTable({
                    dom: '<"pl-2 pt-2 pr-2 pb-2" <"row" <"col-lg-6" l><"col-lg-3" f><"col-lg-12 text-right" B>> > rt <"border-top pl-2 pt-2 pr-2 pb-2 " <"row" <"col-lg-6" i><"col-lg-6" p>> >',
                    buttons: [{
                            text: '<i class="fa fa-plus-circle">Add Product</i>',
                            className: 'btn btn-sm btn-success',
                            action: function(e, dt, node, config) {
                                window.location.href = '{{ route('backend.product.create') }}';
                            }
                        }
                        // , {
                        //     text: '<i class="fa fa-plus-circle">Add multiple product</i>',
                        //     className: 'btn btn-warning btn-sm',
                        //     action: function(e, dt, node, config) {
                        //         window.location.href = '{{ route('backend.productCSVUplode.add') }}';
                        //     }
                        // }, {
                        //     text: '<i class="fa fa-plus-circle">Add product multiple combination</i>',
                        //     className: 'btn btn-info btn-sm',
                        //     action: function(e, dt, node, config) {
                        //         window.location.href =
                        //             '{{ route('backend.productCSVUplode.add_comdication') }}';
                        //     }
                        // }
                    ],
                    lengthChange: false,
                    searching: false,
                    info: true,
                    paging: true,
                    searchHighlight: false,
                    ordering: false,
                    autoWidth: false,
                    responsive: true,
                    processing: true,
                    serverSide: true,
                    stateSave: false,
                    deferRender: true,
                    pageLength: 10,
                    order: false,
                    columnDefs: [{
                            orderable: false,
                            targets: [0, 1, 2, 3]
                        },
                        {
                            className: 'text-center',
                            targets: [0, 1, 2, 3]
                        },
                        {
                            width: '30px',
                            targets: 3
                        }
                    ],
                    ajax: {
                        url: '{{ route('backend.product.index') }}',
                        dataType: 'json',
                        type: 'GET',
                    },
                    columns: [{
                            data: 'background_image'
                        }, {
                            data: 'image'
                        },
                        {
                            data: 'name'
                        },
                        // {
                        //     data: 'cabinet'
                        // },
                        // {
                        //     data: 'model_number'
                        // },
                        {
                            data: 'category'
                        },
                        {
                            data: 'color_master'
                        },
                        {
                            data: 'color'
                        },
                        // {
                        //     data: 'color_id'
                        // },
                        // {
                        //     data: 'door_style_id'
                        // },
                        {
                            data: 'status'
                        }, {
                            data: 'action'
                        }
                    ]
                });
            });
        </script>
    @endpush
@endsection
