@extends('backend.layouts.main')
@section('title', 'Multiple Product')
@section('sections')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Multiple Product</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('backend.product.index') }}">Product</a>
                            </li>
                            <li class="breadcrumb-item active">Multiple Product</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col">
                        @include('backend.common.message')
                    </div>
                </div>
                <div class="card" style="padding: 20px 10px;">
                    <form action="{{ route('backend.productCSVUplode.import') }}" method="POST" autocomplete="off"
                        enctype="multipart/form-data">
                        @csrf
                        @method('POST')
                        <div class="row">
                            <div class="col-md-3">
                                <input type="file" class="form-control" name="csv" class="type-1">
                            </div>
                            <div class="col-md-3">
                                <button type="submit" class="btn btn-outline-primary w-100">
                                    <i class="fa fa-upload" aria-hidden="true"></i>
                                    Upload Product
                                </button>
                            </div>
                            <div class="col-md-3">
                                <a download="Product" href="{{ asset('productCSV/product.csv') }}" title="Product"><button
                                        type="button" class="btn btn-outline-info  w-100">
                                        <i class="fa fa-download" aria-hidden="true"></i>
                                        Download Product Sample
                                    </button></a>
                            </div>

                        </div>
                    </form>
                </div>



            </div>
        </section>
    </div>

    @push('scripts')
        <script type="text/javascript">
            var x = 0;
            $(document).ready(function() {

                $('.select2bs4').select2({
                    theme: 'bootstrap4'
                })

            });
        </script>
    @endpush
@endsection
