@extends('backend.layouts.main')
@section('title', 'Product Combination')
@section('sections')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Product Combination</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('backend.product.index') }}">Product</a>
                            </li>
                            <li class="breadcrumb-item active">Product Combination</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col">
                        @include('backend.common.message')
                    </div>
                </div>
                <div class="card" style="padding: 20px 10px;">
                    <form action="{{ route('backend.productCSVUplode.import_comdication') }}" method="POST"
                        autocomplete="off" enctype="multipart/form-data">
                        @csrf
                        @method('POST')
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <select class="form-control select2bs4" name="product_id">
                                        <option value="" hidden>Select Product</option>
                                        @if (count($products) != 0)
                                            @foreach ($products as $product)
                                                <option value="{{ $product->id }}"
                                                    @if (old('product') == $product->id) selected @endif>
                                                    {{ $product->name }}
                                                </option>
                                            @endforeach
                                        @endif
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <input type="file" class="form-control" name="csv" class="type-1">
                            </div>
                            <div class="col-md-3">
                                <button type="submit" class="btn btn-outline-primary w-100">
                                    <i class="fa fa-upload" aria-hidden="true"></i>
                                    Upload Combinations
                                </button>
                            </div>
                            <div class="col-md-3">
                                <a download="Product" href="{{ asset('productCSV/combination.csv') }}"
                                    title="Product"><button type="button" class="btn btn-outline-info  w-100">
                                        <i class="fa fa-download" aria-hidden="true"></i>
                                        Download Sample
                                    </button></a>
                            </div>

                        </div>
                    </form>
                </div>



            </div>
        </section>
    </div>

    @push('scripts')
        <script type="text/javascript">
            var x = 0;
            $(document).ready(function() {

                $('.select2bs4').select2({
                    theme: 'bootstrap4'
                })

            });
        </script>
    @endpush
@endsection
