@extends('backend.layouts.main')
@section('title', 'Show')
@section('sections')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Show</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('backend.quote.index') }}">Quote</a>
                            </li>
                            <li class="breadcrumb-item active">Show</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col">
                        @include('backend.common.message')
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <a class="btn btn-sm btn-secondary" href="{{ route('backend.quote.index') }}">
                            <i class="fa fa-arrow-left" aria-hidden="true"></i>
                        </a>
                    </div>
                    <form action="{{ route('backend.quote.update', $quote) }}" method="POST" autocomplete="off"
                        enctype="multipart/form-data">

                        <div class="card-body">

                            <table class="table" style="width:100%">
                                <tr>
                                    <th>Question</th>
                                    <th>Answer</th>
                                </tr>
                                <tr>
                                    <td>Image</td>
                                    <td>
                                        @if (!empty($quote->image))
                                            <img src="{{ asset($quote->image) }}" class="type-1">
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td>Name</td>
                                    <td>{{ $quote->name ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td>Company Name</td>
                                    <td>{{ $quote->company_name ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td>Email</td>
                                    <td><a href="mailto:{{ $quote->email }}">{{ $quote->email ?? '-' }}</a></td>
                                </tr>
                                <tr>
                                    <td>Phone No</td>
                                    <td><a href="{{ $quote->phone }}">{{ $quote->phone ?? '-' }}</a></td>
                                </tr>
                                <tr>
                                    <td>Your space</td>
                                    <td>{{ $quote->your_space ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td>Project type</td>
                                    <td>{{ $quote->project_type ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td>Project</td>
                                    <td>{{ $quote->project ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td>Interested</td>
                                    <td>{{ $quote->interested ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td>Budget range </td>
                                    <td>{{ $quote->budget_range ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td>Estimated project timeline</td>
                                    <td>{{ $quote->project_timeline ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td>Location</td>
                                    <td>{{ $quote->location ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td>Messages</td>
                                    <td>{{ $quote->messages ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td>Created at</td>
                                    <td>{{ Carbon\Carbon::parse($quote->created_at)->format('d-M-Y') ?? '-' }}</td>
                                </tr>
                            </table>
                        </div>

                    </form>
                </div>
            </div>
        </section>
    </div>

    @push('scripts')
        <script type="text/javascript">
            $(document).ready(function() {

                $('.select2bs4').select2({
                    theme: 'bootstrap4'
                })

            });
        </script>
    @endpush
@endsection
