@extends('backend.layouts.main')
@section('title', 'Details')
@section('sections')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Details</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('backend.orders.index') }}">Orders</a>
                            </li>
                            <li class="breadcrumb-item active">Details</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        @include('backend.common.message')
                    </div>
                </div>
                <div class="card">
                    <div class="card-header">
                        <a class="btn btn-sm btn-secondary" href="{{ route('backend.orders.index') }}">
                            <i class="fa fa-arrow-left" aria-hidden="true"></i>
                        </a>
                    </div>

                    <div class="card-body">
                        <div class="invoice p-3 mb-3">
                            <div class="row invoice-info">
                                <div class="col-sm-3 invoice-col">
                                    <h5><u>Customer Details</u></h5>
                                    <address>
                                        <b>Name:</b>
                                        {{ $order->user_details->name }}<br>
                                        @if (isset($order->user_details->mobile) && !empty($order->user_details->mobile))
                                            <b>Phone:</b> {{ $order->user_details->mobile ?? '-' }}<br>
                                        @endif
                                        <b>Email:</b> {{ $order->user_details->email ?? '-' }}
                                    </address>
                                </div>
                                <div class="col-sm-3 invoice-col">
                                    <h5><u>User Address</u></h5>
                                    <address>
                                        <b>Address:</b> {{ $order->order_details->address ?? '-' }}<br>
                                        <b>Apartment:</b> {{ $order->order_details->apartment ?? '-' }}<br>
                                        <b>City:</b> {{ $order->order_details->city ?? '-' }}<br>
                                        <b>State:</b> {{ $order->order_details->state ?? '-' }}<br>
                                        <b>Pincode:</b> {{ $order->order_details->pincode ?? '-' }}<br>
                                    </address>
                                </div>
                                <div class="col-sm-3 invoice-col">
                                    <h5><u>Order Details</u></h5>
                                    <address>
                                        <b>Order ID:</b> {{ $order->order_id }}<br>
                                        <b>Order
                                            date:</b>
                                        {{ date('d F Y, h:i A', strtotime($order->created_at)) ?? '-' }}
                                        <br>
                                    </address>
                                </div>
                                <div class="col-sm-3 invoice-col">
                                    <h5><u>Pricing</u></h5>
                                    <ul style="list-style-type: none;padding-left: 0;">
                                        <li><b>Subtotal:</b>$ {{ number_format($order->sub_total, 2, '.', '') }}</li>
                                        @if (!empty($order->coupon_discount) || $order->coupon_discount != 0)
                                            <li><b>Discount Price:</b>$
                                                {{ number_format($order->coupon_discount, 2, '.', '') }}</li>
                                        @endif
                                        <li><b>Delivery Charge:</b>$
                                            {{ number_format($order->delivery_charge, 2, '.', '') }}</li>
                                        <li><b>Total:</b>$ {{ number_format($order->total, 2, '.', '') }}</li>
                                    </ul>
                                </div>
                                {{-- <div class="col-sm-2 invoice-col">
                                    <h5>Payment Details</h5>
                                    <address>
                                        <b>Payment Mode:</b> CASH<br>
                                        <b>Reference Id:</b> <br>
                                        <b>Transaction Id:</b> <br>
                                    </address>
                                </div> --}}
                            </div>

                            <div class="row">
                                <div class="col-12">
                                    <h5><u>Orders</u></h5>
                                </div>
                                <div class="col-12 table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                {{--                                                <th>Image</th> --}}
                                                <th>Category</th>
                                                <th>Product Name</th>
                                                <th>Product Type</th>
                                                <th>Tag Name</th>
                                                <th>Length Name</th>
                                                <th>Color Name</th>
                                                <th>Combinition Name</th>
                                                <th>Quantity</th>
                                                <th>Price</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @if (!empty($order_details))
                                                @foreach ($order_details as $orderDetail)
                                                    <tr>
                                                        {{--                                                        <td><img src="{{ asset($orderDetail->image) }}" class="type-1"> --}}
                                                        {{--                                                        </td> --}}
                                                        <td>{{ $orderDetail->product->type->name ?? '-' }}</td>
                                                        <td>{{ $orderDetail->product->name ?? '-' }}</td>
                                                        <td>{{ $orderDetail->product_type_name ?? '-' }}</td>
                                                        <td>{{ $orderDetail->tag_name ?? '-' }}</td>
                                                        <td>{{ $orderDetail->length_name ?? '-' }}</td>
                                                        <td>{{ $orderDetail->color_name ?? '-' }}</td>
                                                        <td>{{ $orderDetail->name ?? '-' }}</td>
                                                        <td>
                                                            {{ $orderDetail->quantity ?? '-' }}
                                                        </td>
                                                        <td>$ {{ number_format($orderDetail->payable_price, 2, '.', '') }}
                                                        </td>

                                                    </tr>
                                                @endforeach
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </div>
                    </div>
                    {{--
                    <div class="card-body">
                        <div class="invoice p-3 mb-3">
                            <div class="row">
                                <div class="col-12">
                                    <h4>
                                        <i class="fas fa-globe"></i> Order History
                                        <small class="float-right"></small>
                                    </h4>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <table class="table table-striped text-center">
                                        <thead>
                                            <tr>
                                                <th>Created At</th>
                                                <th>Status</th>
                                                <th>Commend</th>
                                                <th>Customer Notified</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @if (isset($order->orderHistory) && !empty($order->orderHistory))
                                                @foreach ($order->orderHistory as $orderHistory)
                                                    <tr>
                                                        <td>{{ Carbon\Carbon::parse($orderHistory->created_at)->format('Y-m-d H:i A') }}
                                                        </td>
                                                        <td>{{ $orderHistory->status->title_en }}</td>
                                                        <td>{{ $orderHistory->comment }}</td>
                                                        <td>{{ $orderHistory->notify == 1 ? 'Yes' : 'No' }}</td>
                                                    </tr>
                                                @endforeach
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <hr>
                            <div class="row">
                                <div class="col-md-12">
                                    <form action="{{ route('backend.order.status') }}" method="post">
                                        @csrf
                                        <input type="hidden" name="order_id" value="{{ $order->id }}">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label>Order Status</label>
                                                    <select class="form-control" name="order_status" required>
                                                        <option value="" selected hidden>Select order status</option>
                                                        @if (!empty($orderStatus))
                                                            @foreach ($orderStatus as $status)
                                                                <option value="{{ $status->id }}">
                                                                    {{ $status->title_en }}
                                                                </option>
                                                            @endforeach
                                                        @endif
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="comment">Comment</label>
                                                    <input type="text" class="form-control" id="comment"
                                                        name="comment">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="status">Notified</label>
                                                    <select class="form-control select2bs4" name="notified">
                                                        <option value="" hidden>---Select---</option>
                                                        <option value="1" selected>
                                                            Yes
                                                        </option>
                                                        <option value="0">
                                                            No
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="d-flex justify-content-end">
                                                    <button type="submit" class="btn btn-primary">Create</button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div> --}}
                </div>
            </div>
        </section>
    </div>
@endsection
