@extends('backend.layouts.main')
@section('sections')
    <div class="content-wrapper" style="min-height: 357px;">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Our Services</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a> </li>
                            <li class="breadcrumb-item active">Our Services</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Our Services</h3>
                            </div>
                            <div class="card-body">
                                @if (session()->has('success'))
                                    <div class="alert alert-success">
                                        {{ session()->get('success') }}
                                    </div>
                                @endif
                                <form action="{{ route('backend.ourServicesMain.update', 1) }}" method="POST"
                                    autocomplete="off" enctype="multipart/form-data">
                                    {{ csrf_field() }}
                                    @method('PUT')
                                    <div class="row">
                                        @if (!empty($main->image1))
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="image">Preview Image1</label>
                                                    <img src="{{ asset($main->image1) }}" class="type-1">
                                                </div>
                                            </div>
                                        @endif
                                        @if (!empty($main->image2))
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="image">Preview Image2</label>
                                                    <img src="{{ asset($main->image2) }}" class="type-1">
                                                </div>
                                            </div>
                                        @endif
                                        @if (!empty($main->image3))
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="image">Preview Image3</label>
                                                    <img src="{{ asset($main->image3) }}" class="type-1">
                                                </div>
                                            </div>
                                        @endif

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="image1">Image1</label>
                                                <input type="file" class="form-control" id="image1" name="image1"
                                                    class="type-1">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="image2">Image2</label>
                                                <input type="file" class="form-control" id="image2" name="image2"
                                                    class="type-1">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="image3">Image3</label>
                                                <input type="file" class="form-control" id="image3" name="image3"
                                                    class="type-1">
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Name</label>
                                                <input type="text" class="form-control" name="name" placeholder="Name"
                                                    value="{{ $main->name ?? '' }}">
                                            </div>

                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Title1</label>
                                                <input type="text" class="form-control" name="title1"
                                                    placeholder="Title1" value="{{ $main->title1 ?? '' }}">
                                            </div>

                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Title2</label>
                                                <input type="text" class="form-control" name="title2"
                                                    placeholder="Title2" value="{{ $main->title2 ?? '' }}">
                                            </div>

                                        </div>


                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Description1</label>
                                                <textarea type="text" class="form-control"id="description1" name="description1" rows="5"
                                                    placeholder="Description1">{!! $main->description1 ?? '' !!}</textarea>
                                            </div>

                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Description2</label>
                                                <textarea type="text" class="form-control"id="description2" name="description2" rows="5"
                                                    placeholder="Description2">{!! $main->description2 ?? '' !!}</textarea>
                                            </div>

                                        </div>


                                        <div class="col-md-12 mt-3" style="text-align: right">
                                            <div class="form-group">
                                                <button type="submit" class="btn btn-primary">Submit</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @push('scripts')
        <script>
            $(document).ready(function() {
                $('#description1').summernote();
                $('#description2').summernote();

            });
        </script>
    @endpush
@endsection
