@extends('backend.layouts.main')
@section('title', 'Edit')
@section('sections')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Edit</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('backend.proMember.index') }}">Pro Member</a>
                            </li>
                            <li class="breadcrumb-item active">Edit</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col">
                        @include('backend.common.message')
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <a class="btn btn-sm btn-secondary" href="{{ route('backend.proMember.index') }}">
                            <i class="fa fa-arrow-left" aria-hidden="true"></i>
                        </a>
                    </div>
                    <div class="invoice p-3 mb-3">
                        <div class="row invoice-info">
                            <div class="col-sm-3 invoice-col">
                                <h5><u>Customer Details</u></h5>
                                <address>
                                    <b>Image:</b>
                                    <img src="{{ asset($user->avatar) }}" class="type-1"
                                        style="width: 100px;border-radius: 50%;"><br>
                                    <b>Name:</b>
                                    {{ $user->name }}<br><b>Company Name:</b>
                                    {{ $user->c_name }}<br>
                                    @if (isset($user->mobile) && !empty($user->mobile))
                                        <b>Phone:</b> {{ $user->mobile ?? '-' }}<br>
                                    @endif
                                    <b>Email:</b> {{ $user->email ?? '-' }}
                                </address>
                            </div>
                            <div class="col-sm-3 invoice-col">
                                <h5><u>User Address</u></h5>
                                <address>
                                    <b>Permanent Address:</b> {{ $user->address ?? '-' }}<br>
                                    <b>Address:</b> {{ $user->address2 ?? '-' }}<br>
                                    <b>City:</b> {{ $user->city ?? '-' }}<br>
                                    <b>State:</b> {{ $user->state_name->name ?? '-' }}<br>
                                    <b>Country:</b> {{ $user->country_name->name ?? '-' }}<br>
                                    <b>Pincode:</b> {{ $user->zipcode ?? '-' }}<br>
                                </address>
                            </div>
                            <div class="col-sm-3 invoice-col">
                                <h5><u>Details</u></h5>
                                <address>

                                    <b>Option 1:</b> {{ $user->option1 ?? '-' }}<br>
                                    <b>Option 2:</b> {{ $user->option2 ?? '-' }}<br>
                                    <b>Option 3:</b> {{ $user->option3 ?? '-' }}<br>
                                    <b>Option 4:</b> {{ $user->option4 ?? '-' }}<br>
                                    <b>Description:</b> {{ $user->description ?? '-' }}<br>

                                </address>
                            </div>

                        </div>
                    </div>
                    <form action="{{ route('backend.proMember.update', $user) }}" method="POST" autocomplete="off"
                        enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="status">Pro member</label>
                                        @if ($user->status == 1)
                                            <input type="text" class="form-control" value="Approve">
                                            <input type="hidden" class="form-control" name="is_pro_member" value="1">
                                        @else
                                            <select class="form-control select2bs4" name="is_pro_member"
                                                onchange="getPro(this.value)">
                                                <option value="1" @if ($user->status == 1) selected @endif>
                                                    Approve
                                                </option>
                                                <option value="0" @if ($user->status == 2) selected @endif>
                                                    Rejecte
                                                </option>
                                            </select>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-6" @if ($user->status == 1 || $user->status == 0) style="display: none" @endif
                                    id='reason'>
                                    <div class="form-group">
                                        <label for="reason">Reason</label>
                                        <textarea class="form-control" name="reason">{{ $user->reason ?? '' }}</textarea>
                                    </div>
                                </div>


                            </div>
                        </div>
                        @if ($user->status == 2 || $user->status == 0)
                            <div class="card-footer d-flex justify-content-end">
                                <button type="submit" class="btn btn-primary">Update</button>
                            </div>
                        @endif
                    </form>
                </div>
            </div>
        </section>
    </div>

    @push('scripts')
        <script type="text/javascript">
            function getPro(id) {
                console.log(id);
                var reason = document.getElementById("reason");
                if (id == 0) {
                    reason.style.display = "block";
                } else {
                    reason.style.display = "none";
                }
            }
        </script>
    @endpush
@endsection
