@extends('backend.layouts.main')
@section('title', 'Edit')
@section('sections')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Edit</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('backend.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item">Settings</li>
                            <li class="breadcrumb-item active">Edit</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                <div class="row">
                    <div class="col">
                        @include('backend.common.message')
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <a class="btn btn-sm btn-secondary" href="{{ route('backend.dashboard') }}">
                            <i class="fa fa-arrow-left" aria-hidden="true"></i>
                        </a>
                    </div>
                    <form action="{{ route('backend.settings.update', $setting) }}" method="POST" autocomplete="off"
                        enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="image">Preview Site Logo</label>
                                        <img src="{{ asset($setting->site_logo) }}" class="type-1">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="image">Preview Site Fav Icon</label>
                                        <img src="{{ asset($setting->site_fav_icon) }}" class="type-1">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="site_logo">Site Logo</label>
                                        <input type="file" class="form-control" id="site_logo" name="site_logo"
                                            class="type-1">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="site_fav_icon">Site Fav Icon</label>
                                        <input type="file" class="form-control" id="site_fav_icon" name="site_fav_icon">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="site_name">Site Name</label>
                                        <input type="text" class="form-control" id="site_name" name="site_name"
                                            placeholder="Enter site name here" value="{{ $setting->site_name }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="copyright">Copyright</label>
                                        <input type="text" class="form-control" id="copyright" name="copyright"
                                            placeholder="Enter copyright here" value="{{ $setting->copyright }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="facebook">Facebook</label>
                                        <input type="text" class="form-control" id="facebook" name="facebook"
                                            placeholder="Enter facebook here" value="{{ $setting->facebook }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="google_plus_alpharetta">Google plus alpharetta</label>
                                        <input type="text" class="form-control" id="google_plus_alpharetta"
                                            name="google_plus_alpharetta" placeholder="Enter google plus alpharetta here"
                                            value="{{ $setting->google_plus_alpharetta }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="google_plus_norcross">Google plus norcross</label>
                                        <input type="text" class="form-control" id="google_plus_norcross"
                                            name="google_plus_norcross" placeholder="Enter google plus norcross here"
                                            value="{{ $setting->google_plus_norcross }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="google_review_alpharetta">Google review alpharetta</label>
                                        <input type="text" class="form-control" id="google_review_alpharetta"
                                            name="google_review_alpharetta"
                                            placeholder="Enter google review alpharetta here"
                                            value="{{ $setting->google_review_alpharetta }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="google_review_norcross">Google review norcross</label>
                                        <input type="text" class="form-control" id="google_review_norcross"
                                            name="google_review_norcross" placeholder="Enter google review norcross here"
                                            value="{{ $setting->google_review_norcross }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="instagram">Instagram</label>
                                        <input type="text" class="form-control" id="instagram" name="instagram"
                                            placeholder="Enter instagram here" value="{{ $setting->instagram }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="phone_call">Phone Call</label>
                                        <input type="text" class="form-control" id="phone_call" name="phone_call"
                                            placeholder="Enter phone call here" value="{{ $setting->phone_call }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="phone_whatsapp">Phone Whatsapp</label>
                                        <input type="text" class="form-control" id="phone_whatsapp"
                                            name="phone_whatsapp" placeholder="Enter phone whatsapp here"
                                            value="{{ $setting->phone_whatsapp }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="email">Email</label>
                                        <input type="email" class="form-control" id="email" name="email"
                                            placeholder="Enter email here" value="{{ $setting->email }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="map">Map</label>
                                        <input type="text" class="form-control" id="map" name="map"
                                            placeholder="Enter map here" value="{{ $setting->map }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="map1">Map 1</label>
                                        <input type="text" class="form-control" id="map1" name="map1"
                                            placeholder="Enter map1 here" value="{{ $setting->map1 }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="address">Address</label>
                                        <input type="text" class="form-control" id="address" name="address"
                                            placeholder="Enter address here" value="{{ $setting->address }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="address1">Address 1</label>
                                        <input type="text" class="form-control" id="address1" name="address1"
                                            placeholder="Enter address1 here" value="{{ $setting->address1 }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="time">Time</label>
                                        <input type="text" class="form-control" id="time" name="time"
                                            placeholder="Enter time here" value="{{ $setting->time }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label for="time">Delivery Charge</label>
                                        <input type="text" class="form-control" id="delivery_charge"
                                            name="delivery_charge" placeholder="Enter delivery charge here"
                                            onkeypress='return event.charCode >= 48 && event.charCode <= 57'
                                            value="{{ $setting->delivery_charge }}">
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="descraption">Descraption</label>
                                        <textarea class="form-control" name="descraption" placeholder="Enter descraption here" rows="5"
                                            cols="5">{!! $setting->descraption !!}</textarea>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="footer_text">Footer Text</label>
                                        <textarea class="form-control" id="summernote" name="footer_text" placeholder="Enter footer text here"
                                            rows="5" cols="5">{!! $setting->footer_text !!}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </div>

    @push('scripts')
        <script type="text/javascript">
            $(document).ready(function() {
                $('#summernote').summernote()
                $('.select2bs4').select2({
                    theme: 'bootstrap4'
                });
            });
        </script>
    @endpush
@endsection
