@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <!-- account section -->
    <div class="account-main-section margin_top">
        <div class="container">
            <div class="form-area">
                <form action="{{ route('frontend.sign_in') }}" enctype="multipart/form-data" method="POST">
                    @csrf
                    @include('backend.common.message')
                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" name="user_email" placeholder="Email" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Password</label>
                        <input type="password" name="user_password" placeholder="Password" class="form-control">
                    </div>
                    <div class="btn-area">
                        <button type="submit" class="btn">Sign In</button>
                    </div>
                    <div class="resetbtn-area">
                        <p><a href="{{ route('frontend.signUp') }}">Register now!</a></p>
                        <p><a href="{{ route('frontend.forget_password') }}">Reset Password</a></p>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
