@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <!-- account section -->
    <div class="account-main-section">
        <div class="container">
            <div class="form-area part2">
                <form action="{{ route('frontend.sign_up_submit') }}" enctype="multipart/form-data" autocomplete="off"
                    method="POST">
                    @csrf
                    @include('backend.common.message')

                    <div class="area1">
                        <h3><span class="icon"></span>Contact Information</h3>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Full Name *</label>
                                    <input type="text" placeholder="" name='name' class="form-control">
                                </div>
                            </div>
                            {{-- <div class="col-md-4">
                                <div class="form-group">
                                    <label>Last Name *</label>
                                    <input type="text" placeholder="" name='l_name' class="form-control">
                                </div>
                            </div> --}}
                            {{-- <div class="col-md-4">
                                <div class="form-group">
                                    <label>Company Name *</label>
                                    <input type="text" placeholder="" name='c_name' class="form-control">
                                </div>
                            </div> --}}
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Email *</label>
                                    <input type="email" placeholder="" name='email' class="form-control">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Phone Number *</label>
                                    <input type="text" placeholder="" name='phone' class="form-control">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Password *</label>
                                    <input type="text" placeholder="" name='password' class="form-control">
                                </div>
                            </div>
                        </div>

                    </div>

                    {{-- <div class="area1">
                        <h3><span class="icon"></span>Address Information</h3>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Street Address *</label>
                                    <input type="text" placeholder="" name='address' class="form-control">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Street Address 2</label>
                                    <input type="text" placeholder="" name='address2' class="form-control">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>City *</label>
                                    <input type="text" placeholder="" name='city' class="form-control">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Zip Code *</label>
                                    <input type="text" placeholder="" name='zipcode' class="form-control">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Country *</label>
                                    <select name="country" id="" class="form-control <!--js-example-basic-single-->"
                                            onchange="getStates(this.value)">
                                        <option value="">Select country</option>
                                        @if (!empty($countries))
                                            @foreach ($countries as $country)
                                                <option value="{{$country->id}}">{{$country->name}}</option>
                                            @endforeach
                                        @endif
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group" id="state_div">

                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="area1">
                        <h3><span class="icon"></span> Additional Information <span class="textsmall">(website url, hours,
                                etc)</span></h3>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Additional Information</label>
                                    <textarea name="description" id="" cols="3" class="form-control"
                                              style="height: 80px;"></textarea>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" name='option1' type="checkbox"
                                                   value="I have a cabinetry showroom and would like to become a dealer"
                                                   id="flexCheckDefault1">
                                            <label class="form-check-label" for="flexCheckDefault1">
                                                I have a cabinetry showroom and would like to become a dealer
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" name='option2' type="checkbox"
                                                   value="I would like to install cabinets in my local market"
                                                   id="flexCheckDefault2">
                                            <label class="form-check-label" for="flexCheckDefault2">
                                                I would like to install cabinets in my local market
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" name='option3' type="checkbox"
                                                   value="I am an interior designer" id="flexCheckDefault3">
                                            <label class="form-check-label" for="flexCheckDefault3">
                                                I am an interior designer
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" name='option4' type="checkbox"
                                                   value="I am a contractor" id="flexCheckDefault4">
                                            <label class="form-check-label" for="flexCheckDefault4">
                                                I am a contractor
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="area1 mb-0">
                        <h3><span class="icon"></span>Annual Registration, Tax Exempt(If any) or Resale Certificate</h3>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Select or Drag'n'drop your document below</label>
                                    <div class="input-group">
                                        <input type="file" name='image' class="form-control" id="inputGroupFile04"
                                               aria-describedby="inputGroupFileAddon04" aria-label="Upload">
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div> --}}


                    <div class="btn-area area002">
                        <button type="submit" class="btn">Submit Registration</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    @push('scripts')
        <script>
            function getStates(country_id) {
                $.ajax({
                    url: "{{ route('frontend.get_states') }}",
                    type: "post",
                    data: {
                        _token: '{{ csrf_token() }}',
                        country_id: country_id
                    },
                    success: function(response) {
                        if (response.status == 'success') {
                            let html = `<label>State / Province</label>
                                    <select name="state" id="" class="form-control">`;
                            response.data.forEach((element) => {
                                html += `<option value="${element.id}">${element.name}</option>`;
                            });
                            html += `</select>`;
                            $("#state_div").html(html);
                        }
                        // You will get response from your PHP page (what you echo or print)
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    }
                });
            }
        </script>
    @endpush
@endsection
