@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <!-- account section -->
    <div class="account-main-section margin_top">
        <div class="container">
            <div class="form-area part2">
                <form action="{{ route('frontend.user_address_submit') }}" enctype="multipart/form-data" method="POST">
                    @csrf
                    @include('backend.common.message')

                    <div class="area1">
                        <h3><span class="icon"></span>Address Information</h3>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Street Address *</label>
                                    <input type="text" placeholder="" name='address' class="form-control"
                                        value="{{ $address->address ?? null }}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>City *</label>
                                    <input type="text" placeholder="" name='city' class="form-control"
                                        value="{{ $address->city ?? null }}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Apartment</label>
                                    <input type="text" placeholder="" name='apartment' class="form-control"
                                        value="{{ $address->apartment ?? null }}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Zip Code *</label>
                                    <input type="text" placeholder="" name='pincode' class="form-control"
                                        value="{{ $address->pincode ?? null }}">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Country *</label>
                                    <select name="country" id=""
                                        class="form-control <!--js-example-basic-single-->"
                                        onchange="getStates(this.value)">
                                        <option value="">Select country</option>
                                        @if (!empty($countries))
                                            @foreach ($countries as $country)
                                                <option value="{{ $country->id }}"
                                                    @if (!empty($address->country) && $address->country == $country->id) selected @endif>
                                                    {{ $country->name }}</option>
                                            @endforeach
                                        @endif
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group" id="state_div">
                                    <label>State / Province</label>
                                    <select name="state" id="" class="form-control">
                                        <option value="">Select state</option>
                                        @if (!empty($states))
                                            @foreach ($states as $state)
                                                <option value="{{ $state->id }}"
                                                    @if (!empty($address->state) && $address->state == $state->id) selected @endif>
                                                    {{ $state->name }}</option>
                                            @endforeach
                                        @endif
                                    </select>
                                </div>
                            </div>
                        </div>

                    </div>


                    <div class="btn-area area002">
                        <button type="submit" class="btn">Update Address</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            function getStates(country_id) {
                $.ajax({
                    url: "{{ route('frontend.get_states') }}",
                    type: "post",
                    data: {
                        _token: '{{ csrf_token() }}',
                        country_id: country_id
                    },
                    success: function(response) {
                        if (response.status == 'success') {
                            let html = `<label>State / Province</label>
                                    <select name="state" id="" class="form-control">`;
                            response.data.forEach((element) => {
                                html += `<option value="${element.id}">${element.name}</option>`;
                            });
                            html += `</select>`;
                            $("#state_div").html(html);
                        }
                        // You will get response from your PHP page (what you echo or print)
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.log(textStatus, errorThrown);
                    }
                });
            }
        </script>
    @endpush
@endsection
