@php
    $segment = Request::segment(1);
    if (!empty($_SERVER['QUERY_STRING'])) {
        $value = explode('=', $_SERVER['QUERY_STRING']);
    }
@endphp
    <!doctype html>
<html lang="en">

<head>
    <!-- Google Tag Manager -->
    <script>(function (w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                'gtm.start':
                    new Date().getTime(), event: 'gtm.js'
            });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s), dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src =
                'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', 'GTM-P5QGTFS4');</script>
    <!-- End Google Tag Manager -->
    <meta charset="utf-8">
    @yield('meta_tag')
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="{{ url('/') . '/' . SiteInfo::info()['site_fav_icon'] ?? null }}">
    @include('frontend.layout.css')
    @stack('css')
    @if (route('frontend.index') == url()->current())
        <style>
            .index_header {
                position: absolute;
                width: 100%;
                /*background: #0000008a !important;*/
                z-index: 99;
            }
        </style>
    @else
        <style>
            header {
                position: relative;
                width: 100%;
                /*background: #0000008a !important;*/
                z-index: 99;
            }
        </style>
    @endif
    <script type="application/ld+json">
        {
          "@context": "https://schema.org",
          "@type": "LocalBusiness",
          "@id": "https://homescabinet.com/#localbusiness",
          "name": "HOME CABINET",
          "description": "Homes Cabinet is your go-to destination for the best kitchen and bathroom cabinet store in Atlanta, GA. We offer a wide selection of premium-quality cabinets that combine elegance, durability, and functionality. Whether you're renovating your kitchen or updating your bathroom, our expertly crafted cabinets come in a variety of styles, finishes, and custom options to match your design vision. At Homes Cabinet, we pride ourselves on exceptional customer service, competitive pricing, and top-notch craftsmanship. Our design team works closely with you to create the perfect storage solutions that elevate your home’s aesthetic and value. Visit Homes Cabinet today and let us help you bring your dream kitchen or bathroom to life!",
          "image": "https://homescabinet.com/wp-content/uploads/2022/06/png_son-e1705664999609.png",
          "url": "https://homescabinet.com/",
          "telephone": "+1-470-679-1065",
          "priceRange": "$$",
          "address": {
            "@type": "PostalAddress",
            "streetAddress": "6796 JIMMY CARTER BLVD STE G",
            "addressLocality": "NORCROSS",
            "addressRegion": "GA",
            "postalCode": "30071",
            "addressCountry": "US"
          },
          "geo": {
            "@type": "GeoCoordinates",
            "latitude": 33.922060,
            "longitude": -84.213292
          }
        }
    </script>
</head>

<body>
<noscript>
    <iframe src="https://www.googletagmanager.com/ns.html?id=GTM-P5QGTFS4"
            height="0" width="0"></iframe>
</noscript>
<!-- update header -->
<header class="header-main-sec index_header" id="header2">
    <div class="header-top">
        <div class="container">
            <div class="row">
                <div class="col-md-8 right_info">
                    <ul class="d-flex">
                        <li><i class="fa fa-phone" aria-hidden="true"></i><a
                                href="#">{{ SiteInfo::info()['phone_call'] }} (Norcross)</a></li>
                        <li><i class="fa fa-phone" aria-hidden="true"></i><a
                                href="#">{{ SiteInfo::info()['phone_whatsapp'] }}
                                (Alpharetta)</a></li>
                        <li><i class="fa fa-envelope" aria-hidden="true"></i><a href="#">
                                {{ SiteInfo::info()['email'] }}</a></li>
                    </ul>

                </div>
                <div class="col-md-4 left_info">
                    <ul>
                        <li>
                            <a href="{{ SiteInfo::info()['instagram'] }}" target="_blank">
                               {{-- <i
                                    data-feather="instagram" class="text-white"></i>--}}
                                <i class="fa fa-instagram" aria-hidden="true"></i>
                            </a>
                        </li>
                        <li>
                            <a href="{{ SiteInfo::info()['facebook'] }}" target="_blank">
                                {{--<i
                                    data-feather="facebook" class="text-white"></i>--}}
                                <i class="fa fa-facebook" aria-hidden="true"></i>
                            </a>
                        </li>
                        <li>
                            <a href="{{ SiteInfo::info()['google_plus_alpharetta'] }}" target="_blank">
                                <i class="fa fa-google" aria-hidden="true"></i>
                            </a>
                        </li>
                        @if (auth()->check())
                            <!--<li><a href="{{ route('frontend.my_orders') }}"><i class="fa fa-opencart"-->
                            <!--            aria-hidden="true"></i><span>My Orders</span></a>-->
                            <!--</li>-->

                            <li class="dropdown" onclick="myUserFunction()">
                                <a class="dropbtn"><i class="fa fa-user" aria-hidden="true"></i> <i
                                        class="fa fa-angle-down p-0" aria-hidden="true"></i></a>
                                <div id="myDropdown" class="dropdown-content2">
                                    <a href="{{ route('frontend.user_profile') }}">Profile Update</a>
                                    {{-- <a href="{{ route('frontend.change_password', Auth::user()->email) }}">Password
                                        Update</a>
                                    <a href="{{ route('frontend.user_address') }}">Address Update</a> --}}
                                    {{-- <a href="{{ route('frontend.my_orders') }}">My Orders</a> --}}
                                    <a href="{{ route('frontend.logout') }}">Log Out</a>
                                </div>
                            </li>
                        @else
                            <li><a href="{{ route('frontend.login') }}"><i class="fa fa-key"
                                                                           aria-hidden="true"></i><span>Log In</span></a>
                            </li>
                        @endif
                        {{-- <li><a href="{{ route('frontend.cart_get') }}"><i class="fa fa-shopping-cart"
                                    aria-hidden="true"></i><span>Cart</span>
                                <div class="nom" id="cart_count1">({{ SiteInfo::cartCount() }})</div>
                            </a></li> --}}
                    </ul>
                </div>

            </div>
        </div>
    </div>

    <div class="header-main area1">
        <div class="container">
            <nav id='cssmenu'>
                <div class="logo">
                    <a href="{{ route('frontend.index') }}"><img src="{{ asset(SiteInfo::info()['site_logo']) }}"
                                                                 alt="logo"></a>
                </div>
                <div id="head-mobile"></div>
                <div class="button"></div>
                <ul>

                    <li class="dropdown">
                        <button onclick="myFunction()" class="dropbtn d-flex"><a href="javascript:void(0)"
                                                                                 class="text-white">our
                                services</a>
                            <i class="fa fa-angle-down" aria-hidden="true"></i></button>
                        <div id="myDropdown" class="dropdown-content">
                            <a href="{{ route('frontend.kitchenCabinet') }}">Kitchen Cabinet</a>
                            {{-- @if (!empty(SiteInfo::types()))
                                @foreach (SiteInfo::types() as $type)
                                    <a
                                        href="{{ route('frontend.cabinate_accessories', $type->id) }}">{{ $type->name }}</a>
                                @endforeach
                            @endif --}}
                            @if (!empty(SiteInfo::ourServices()))
                                @foreach (SiteInfo::ourServices() as $ourService)
                                    <a
                                        href="{{ route('frontend.service', $ourService->slug) }}">{{ $ourService->name }}</a>
                                @endforeach
                            @endif
                        </div>
                    </li>
                    <li class="dropdown">
                        <button onclick="myFunctionGallery()" class="dropbtn d-flex"><a href="javascript:void(0)"
                                                                                        class="text-white">Gallery</a>
                            <i class="fa fa-angle-down" aria-hidden="true"></i></button>
                        <div id="myDropdown" class="dropdown-content1">

                            @if (!empty(SiteInfo::categories()))
                                @foreach (SiteInfo::categories() as $category)
                                    <a
                                        href="{{ route('frontend.gallery', ['id' => $category->id, 'type' => 1]) }}">{{ $category->name }}</a>
                                @endforeach
                            @endif
                            @if (!empty(SiteInfo::ourServices()))
                                @foreach (SiteInfo::ourServices() as $ourService)
                                    <a
                                        href="{{ route('frontend.gallery', ['id' => $ourService->id, 'type' => 2]) }}">{{ $ourService->name }}</a>
                                @endforeach
                            @endif
                        </div>
                    </li>
                    <li><a href="{{ route('frontend.blogs') }}">Blogs</a></li>
                    <li><a href="{{ route('frontend.contact') }}">Contact us</a></li>
                    {{-- <li><a href="{{ route('frontend.kitchen_design') }}">Kitchen Design Tool</a></li> --}}
                    {{-- <li><a href="#">Financing</a></li> --}}
                    {{-- <li><a href="{{ route('frontend.pricing') }}">Pricing</a></li> --}}
                    <!--<li><a href="{{ route('frontend.proMember') }}">Become a Pro Member</a></li>-->
                    {{-- <li><a href="#">Resources</a></li> --}}

                    <li><a href='{{ route('frontend.design_help') }}'>Free Design Help</a></li>
                    {{-- <li><a href="{{ route('frontend.type', 1) }}">Shop Kitchen Cabinets </a></li> --}}
                    {{-- <li><a href="{{ route('frontend.cabinate_accessories', 3) }}">Cabinet Accessories </a></li> --}}

                    {{-- <li><input type="text" id="search_product" value="{{ $value[1] ?? null }}"
                            placeholder="Search HOMES Cabinet" class="w-full outline-none"
                            onkeyup="searchProducts()">
                    </li> --}}
                </ul>
                {{-- <ul>
                    @if (!empty(SiteInfo::types()))
                        @foreach (SiteInfo::types() as $type)
                            <li><a href='{{ route('frontend.type', $type->id) }}'>{{ $type->name }}</a></li>
                        @endforeach
                    @endif
                    <li><a href='{{ route('frontend.design_help') }}' class="btn">Free Design Help</a></li>

                </ul> --}}
                <!--<ul class="searchAreaUL">
                        <li class="dropdown">
                            <button onclick="myFunction()" class="dropbtn">our services <i class="fa fa-angle-down"
                                    aria-hidden="true"></i></button>
                            <div id="myDropdown" class="dropdown-content">
                                @if (!empty(SiteInfo::types()))
                    @foreach (SiteInfo::types() as $type)
                        <a href="{{ route('frontend.type', $type->id) }}">{{ $type->name }}</a>






                    @endforeach
                @endif
                @if (!empty(SiteInfo::ourServices()))
                    @foreach (SiteInfo::ourServices() as $ourService)
                        <a
                                                                    href="{{ route('frontend.service', $ourService->slug) }}">{{ $ourService->name }}</a>






                    @endforeach
                @endif
                </div>
            </li>
            <li><a href='{{ route('frontend.design_help') }}' class="btn">Free Design Help</a></li>
                    </ul>-->
            </nav>
        </div>

        <div class="container">
            <div class="scroll-menu">
                <div class="menuarea-3">
                    <div class="part-1">
                        <div class="logo">
                            <a href="{{ route('frontend.index') }}">
                                <img src="{{ asset(SiteInfo::info()['site_logo']) }}" alt="logo">
                            </a>
                        </div>
                        <div class="area1">
                            <ul>
                                <li class="dropdown">
                                    <a class="dropbtn" onclick="myFunction()">our services <i
                                            class="fa fa-angle-down p-0" aria-hidden="true"></i></a>
                                    <div id="myDropdown" class="dropdown-content">
                                        <a href="Kitchen.html">Kitchen Cabinets</a>
                                        <a href="Bathroom.html">Bathroom Vanities</a>
                                        <a href="Hardware.html">Cabinet Hardware</a>
                                    </div>
                                </li>
                                {{-- <li class="dropdown">
                                    <button onclick="myFunction()" class="dropbtn d-flex"><a
                                            href="javascript:void(0)" class="text-white">our services</a>
                                        <i class="fa fa-angle-down" aria-hidden="true"></i></button>
                                    <div id="myDropdown" class="dropdown-content">
                                        <a href="{{ route('frontend.kitchenCabinet') }}">Kitchen Cabinet</a>

                                        @if (!empty(SiteInfo::types()))
                                            @foreach (SiteInfo::types() as $type)
                                                <a
                                                    href="{{ route('frontend.type', $type->id) }}">{{ $type->name }}</a>
                                            @endforeach
                                        @endif
                                        @if (!empty(SiteInfo::ourServices()))
                                            @foreach (SiteInfo::ourServices() as $ourService)
                                                <a
                                                    href="{{ route('frontend.service', $ourService->slug) }}">{{ $ourService->name }}</a>
                                            @endforeach
                                        @endif
                                    </div>
                                </li> --}}
                                <li class="dropdown">
                                    <button onclick="myFunctionGallery()" class="dropbtn d-flex">
                                        <a
                                            href="javascript:void(0)" class="text-white">Gallery</a>
                                        <i class="fa fa-angle-down" aria-hidden="true"></i></button>
                                    <div id="myDropdown" class="dropdown-content1">

                                        @if (!empty(SiteInfo::categories()))
                                            @foreach (SiteInfo::categories() as $category)
                                                <a
                                                    href="{{ route('frontend.gallery', ['id' => $category->id, 'type' => 1]) }}">{{ $category->name }}</a>
                                            @endforeach
                                        @endif
                                        @if (!empty(SiteInfo::ourServices()))
                                            @foreach (SiteInfo::ourServices() as $ourService)
                                                <a
                                                    href="{{ route('frontend.gallery', ['id' => $ourService->id, 'type' => 2]) }}">{{ $ourService->name }}</a>
                                            @endforeach
                                        @endif
                                    </div>
                                </li>
                                {{-- @if (!empty(SiteInfo::types()))
                                    @foreach (SiteInfo::types() as $type)
                                        <li><a
                                                href='{{ route('frontend.type', $type->id) }}'>{{ $type->name }}</a>
                                        </li>
                                    @endforeach
                                @endif --}}
                                <li><a href="{{ route('frontend.design_help') }}" class="btn">Free Design
                                        Help</a></li>
                            </ul>
                        </div>
                    </div>

                    <div class="area2">
                        <ul>
                            @if (auth()->check())
                                <li class="dropdown" onclick="myUserFunction()">
                                    <a class="dropbtn"><i class="fa fa-user" aria-hidden="true"></i> <i
                                            class="fa fa-angle-down p-0" aria-hidden="true"></i></a>
                                    <div id="myDropdown" class="dropdown-content2">
                                        <a href="{{ route('frontend.user_profile') }}">Profile Update</a>
                                        {{-- <a href="{{ route('frontend.change_password', Auth::user()->email) }}">Password
                                            Update</a>
                                        <a href="{{ route('frontend.user_address') }}">Address Update</a> --}}

                                        {{-- <a href="{{ route('frontend.my_orders') }}">My Orders</a> --}}
                                        <a href="{{ route('frontend.logout') }}">Log Out</a>
                                    </div>
                                </li>
                            @else
                                <li><a href="{{ route('frontend.login') }}"><i class="fa fa-key"
                                                                               aria-hidden="true"></i><span>Log
                                                In</span></a></li>
                            @endif
                            {{-- <li>
                                <a href="{{ route('frontend.cart_get') }}"><i class="fa fa-shopping-cart"
                                        aria-hidden="true"></i><span>Cart</span>
                                    <div class="nom" id="cart_count">({{ SiteInfo::cartCount() }})</div>
                                </a>
                            </li> --}}
                        </ul>
                    </div>
                    <div class="smallmenu-hambargar">
                        <span></span>
                    </div>

                </div>
            </div>
        </div>
        <div class="container">
            <div class="scroll-menu-item-area">
                <ul>
                    {{-- @if (!empty(SiteInfo::types()))
                        @foreach (SiteInfo::types() as $type)
                            <li><a href='{{ route('frontend.type', $type->id) }}'>{{ $type->name }}</a>
                            </li>
                        @endforeach
                    @endif --}}
                    <li><a href="{{ route('frontend.kitchenCabinet') }}">Kitchen Cabinet</a></li>
                    {{-- @if (!empty(SiteInfo::types()))
                        @foreach (SiteInfo::types() as $type)
                            <li><a
                                    href="{{ route('frontend.cabinate_accessories', $type->id) }}">{{ $type->name }}</a>
                            </li>
                        @endforeach
                    @endif --}}
                    @if (!empty(SiteInfo::ourServices()))
                        @foreach (SiteInfo::ourServices() as $ourService)
                            <li><a
                                    href="{{ route('frontend.service', $ourService->slug) }}">{{ $ourService->name }}</a>
                            </li>
                        @endforeach
                    @endif
                    <li><a href="{{ route('frontend.blogs') }}">Blogs</a></li>
                    <li><a href="{{ route('frontend.contact') }}">Contact us</a></li>
                    {{-- <li><a href="{{ route('frontend.blogs') }}">Blogs</a></li> --}}
                    <!--<li><a href="{{ route('frontend.proMember') }}">Become a Pro Member</a></li>-->
                    {{-- <li><a href="{{ route('frontend.type', 1) }}">Shop Kitchen Cabinets </a></li> --}}
                    {{-- <li><a href="{{ route('frontend.cabinate_accessories', 3) }}">Cabinet Accessories </a></li> --}}
                    <li><a href='{{ route('frontend.design_help') }}'>Free Design Help</a></li>
                    {{-- <li><a href="{{ route('frontend.quick_ship') }}">Quick Shipping</a></li> --}}
                    {{-- <li><a href="{{ route('frontend.kitchen_design') }}">Kitchen Design Tool</a></li> --}}
                    {{-- <li><a href="#">Financing</a></li> --}}
                    {{-- <li><a href="{{ route('frontend.pricing') }}">Pricing</a></li> --}}
                    {{-- <li><a href="#">Resources</a></li> --}}
                </ul>
            </div>
        </div>
    </div>

    <div class="header-main area2">
        <div class="container">
            <div class="scroll-menu">
                <div class="menuarea-3">
                    <div class="part-1">
                        <div class="logo">
                            <a href="{{ route('frontend.index') }}">
                                <img src="{{ asset(SiteInfo::info()['site_logo']) }}" alt="logo">
                            </a>
                        </div>
                        <div class="area1">
                            <ul>
                                <li class="dropdown">
                                    <button onclick="myFunction()" class="dropbtn d-flex"><a
                                            href="javascript:void(0)" class="text-white">our services</a>
                                        <i class="fa fa-angle-down" aria-hidden="true"></i></button>
                                    <div id="myDropdown" class="dropdown-content">
                                        <a href="{{ route('frontend.kitchenCabinet') }}">Kitchen Cabinet</a>

                                        {{-- @if (!empty(SiteInfo::types()))
                                            @foreach (SiteInfo::types() as $type)
                                                <a
                                                    href="{{ route('frontend.cabinate_accessories', $type->id) }}">{{ $type->name }}</a>
                                            @endforeach
                                        @endif --}}
                                        @if (!empty(SiteInfo::ourServices()))
                                            @foreach (SiteInfo::ourServices() as $ourService)
                                                <a
                                                    href="{{ route('frontend.service', $ourService->slug) }}">{{ $ourService->name }}</a>
                                            @endforeach
                                        @endif
                                    </div>
                                </li>
                                <li class="dropdown">
                                    <button onclick="myFunctionGallery()" class="dropbtn d-flex"><a
                                            href="javascript:void(0)" class="text-white">Gallery</a>
                                        <i class="fa fa-angle-down" aria-hidden="true"></i></button>
                                    <div id="myDropdown" class="dropdown-content1">

                                        @if (!empty(SiteInfo::categories()))
                                            @foreach (SiteInfo::categories() as $category)
                                                <a
                                                    href="{{ route('frontend.gallery', ['id' => $category->id, 'type' => 1]) }}">{{ $category->name }}</a>
                                            @endforeach
                                        @endif
                                        @if (!empty(SiteInfo::ourServices()))
                                            @foreach (SiteInfo::ourServices() as $ourService)
                                                <a
                                                    href="{{ route('frontend.gallery', ['id' => $ourService->id, 'type' => 2]) }}">{{ $ourService->name }}</a>
                                            @endforeach
                                        @endif
                                    </div>
                                </li>
                                {{-- @if (!empty(SiteInfo::types()))
                                    @foreach (SiteInfo::types() as $type)
                                        <li><a
                                                href='{{ route('frontend.type', $type->id) }}'>{{ $type->name }}</a>
                                        </li>
                                    @endforeach
                                @endif --}}
                                {{-- <li><a href="{{ route('frontend.type', 1) }}">Shop Kitchen Cabinets </a></li> --}}
                                {{-- <li><a href="{{ route('frontend.cabinate_accessories', 3) }}">Cabinet Accessories
                                    </a></li> --}}
                                <li><a href="{{ route('frontend.contact') }}">Contact us</a></li>
                                <li><a href="{{ route('frontend.design_help') }}" class="btn">Free Design
                                        Help</a></li>
                            </ul>
                        </div>
                    </div>

                    <div class="area2">
                        <ul>
                            @if (auth()->check())
                                <li class="dropdown" onclick="myUserFunction()">
                                    <a class="dropbtn"><i class="fa fa-user" aria-hidden="true"></i> <i
                                            class="fa fa-angle-down p-0" aria-hidden="true"></i></a>
                                    <div id="myDropdown" class="dropdown-content2">
                                        <a href="{{ route('frontend.user_profile') }}">Profile Update</a>
                                        {{-- <a href="{{ route('frontend.change_password', Auth::user()->email) }}">Password
                                            Update</a>
                                        <a href="{{ route('frontend.user_address') }}">Address Update</a> --}}
                                        {{-- <a href="{{ route('frontend.my_orders') }}">My Orders</a> --}}
                                        <a href="{{ route('frontend.logout') }}">Log Out</a>
                                    </div>
                                </li>
                            @else
                                <li><a href="{{ route('frontend.login') }}"><i class="fa fa-key"
                                                                               aria-hidden="true"></i><span>Log
                                                In</span></a></li>
                            @endif
                            {{-- <li>
                                <a href="{{ route('frontend.cart_get') }}"><i class="fa fa-shopping-cart"
                                        aria-hidden="true"></i><span>Cart</span>
                                    <div class="nom" id="cart_count">({{ SiteInfo::cartCount() }})</div>
                                </a>
                            </li> --}}
                        </ul>
                    </div>
                    <div class="smallmenu-hambargar">
                        <span></span>
                    </div>

                </div>
            </div>
        </div>
    </div>
</header>

@yield('content')

<!-- footer -->

<footer class="footer-section">
    <div class="container">
        <div class="footer-content pt-5 pb-5">
            <div class="row">
                <div class="col-md-6 col-lg-3 mb-50">
                    <div class="footer-widget">
                        <div class="footer-logo">
                            <a href="{{ route('frontend.index') }}"><img
                                    src="{{ asset(SiteInfo::info()['site_logo']) }}" class="img-fluid"
                                    alt="logo"></a>
                        </div>
                        {{-- <div class="footer-text">
                        <p>{{ SiteInfo::info()['descraption'] }}</p>
                    </div> --}}
                        <div class="qr-code-section">
                            <img src="{{asset('qr/qr-1.png')}}"/>
                        </div>
                        <div class="footer-social-icon">
                            <a href="{{ SiteInfo::info()['instagram'] }}" target="_blank">
                                <i class="fa fa-instagram" aria-hidden="true"></i>
                            </a>
                            <a href="{{ SiteInfo::info()['facebook'] }}" target="_blank">
                                <i class="fa fa-facebook" aria-hidden="true"></i>
                            </a>
                            <a href="mailto:{{ SiteInfo::info()['email'] }}" target="_blank"> <i
                                    class="fa fa-envelope-o" aria-hidden="true"></i></a>
                            <a href="https://wa.me/+{{ SiteInfo::info()['phone_whatsapp'] }}" target="_blank"> <i
                                    class="fa fa-whatsapp" aria-hidden="true"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3 col-6 mb-3">
                    <div class="footer-widget">
                        <div class="footer-widget-heading">
                            <h3>Get Help</h3>
                        </div>
                        <ul>
                            <li><a href="{{ route('frontend.index') }}">Home</a></li>
                            <li><a href="{{ route('frontend.about') }}">About us</a></li>
                            <li><a href="{{ route('frontend.contact') }}">Contact us</a></li>
                            <li><a href="{{ route('frontend.faq') }}">FAQ</a></li>
                            <!--<li><a href="{{ route('frontend.proMember') }}">Become a pro member</a></li>-->
                            <li><a href="{{ route('frontend.signUp') }}">Create an account</a></li>
                            @if (auth()->check() == true)
                                {{-- <li><a href="{{ route('frontend.cart_get') }}">Shopping Cart</a></li> --}}
                            @endif

                        </ul>
                    </div>
                </div>
                <div class="col-md-6 col-lg-3 col-6 mb-3">
                    <div class="footer-widget">
                        <div class="footer-widget-heading">
                            <h3>General Info</h3>
                        </div>
                        <ul>
                            <li><a href="{{ route('frontend.customerReviews') }}">Customer Reviews</a></li>
                            <li><a href="{{ route('frontend.refund_policy') }}">Refund Policy</a></li>
                            <li><a href="{{ route('frontend.privacy_policy') }}">Privacy Policy</a></li>
                            <li><a href="{{ route('frontend.terms_and_services') }}">Terms & Services</a></li>
                            <li><a href="{{ route('frontend.return_policy') }}">Return Policy</a></li>
                            {{-- <li><a href="{{ route('frontend.assembly_isntructions') }}">Installation &
                                Assembly</a></li> --}}
                            <li><a href="{{ route('frontend.blogs') }}">Blogs</a></li>
                        </ul>
                    </div>
                </div>

                <div class="col-md-6 col-lg-3 mb-30">
                    <div class="footer-widget">
                        <div class="footer-widget-heading">
                            <!--<h3>Account</h3>--></a>
                            <h3>Location</h3>
                            <div class="footer-text">
                                <p class="text-white">Norcross
                                    <a href="{{ SiteInfo::info()['google_plus_norcross'] }}" target="_blank">
                                        <img src="{{ asset('g1.webp') }}">
                                    </a>
                                </p>

                                <p><a class="map-address"
                                      href="https://www.google.com/maps/place/6796+Jimmy+Carter+Blvd+STE+G,+Norcross,+GA+30071,+USA/@33.9391813,-84.2402713,17z/data=!3m1!4b1!4m6!3m5!1s0x88f5a190ffdaab37:0x5d239667ab456deb!8m2!3d33.9391813!4d-84.2376964!16s%2Fg%2F11vt4sz_80?entry=ttu&g_ep=EgoyMDI1MDMwMy4wIKXMDSoASAFQAw%3D%3D"
                                      target="_blank"><i class="fa fa-map-marker" aria-hidden="true"></i>
                                        {{ SiteInfo::info()['address'] }}</a></p>
                                <p><i class="fa fa-phone" aria-hidden="true"></i>
                                    {{ SiteInfo::info()['phone_call'] }}</p>
                                <p class="text-white">Alpharetta
                                    <a href="{{ SiteInfo::info()['google_plus_alpharetta'] }}" target="_blank">
                                        <img src="{{ asset('g1.webp') }}">
                                    </a>
                                </p>
                                <p><a class="map-address"
                                      href="https://www.google.com/maps/place/1000+North+Point+Cir,+Alpharetta,+GA+30022,+USA/@34.0492659,-84.2979273,17z/data=!3m1!4b1!4m6!3m5!1s0x88f5751471ae99d3:0xdee9ff56228bb6dc!8m2!3d34.0492659!4d-84.2953524!16s%2Fg%2F11bw3g9wmd?entry=ttu&g_ep=EgoyMDI1MDMwMy4wIKXMDSoASAFQAw%3D%3D"
                                      target="_blank"><i class="fa fa-map-marker" aria-hidden="true"></i>
                                        {{ SiteInfo::info()['address1'] }}</a></p>
                                <p><i class="fa fa-phone"
                                      aria-hidden="true"></i> {{ SiteInfo::info()['phone_whatsapp'] }}</p>
                            </div>
                        </div>
                        <ul>
                        </ul>
                    </div>
                </div>
                <!--<div class="col-md-6 col-lg-2 mb-50">-->
                <!--    <div class="custom-from-box">-->
                <!--        <h5>{{ SiteInfo::title()['title10'] ?? null }}</h5>-->
                <!--        <p>{{ SiteInfo::title()['title11'] ?? null }}</p>-->
                <!--        <div class="btn-area">-->
                <!--            <a href="{{ route('frontend.proMember') }}" class="btn">Join Discount Program</a>-->
                <!--        </div>-->
                <!--    </div>-->
                <!--</div>-->
            </div>
        </div>
    </div>
    <!--<div class="payment-way">-->
    <!--    <div class="container">-->
    <!--        <ul>-->
    <!--            <li class="pay-img">-->
    <!--                <img src="{{ asset('frontend/assets/images/footer-logos-black-bg-1.png') }}" alt="">-->
    <!--            </li>-->
    <!--            <li class="pay-img">-->
    <!--                <img src="{{ asset('frontend/assets/images/footer-logos-black-bg-2.webp') }}" alt="">-->
    <!--            </li>-->
    <!--        </ul>-->
    <!--    </div>-->
    <!--</div>-->
    {{-- <div class="brand-area">
        @if (!empty(SiteInfo::brands()))
            <div class="container">
                <div class="headarea-01">
                    <div class="img-area">
                        <img src="{{ asset(SiteInfo::brandsTitle()['image'] ?? null) }}" alt="">
                    </div>
                    <div class="brands-subtitle">
                        <span></span>
                        <h4>{{ SiteInfo::brandsTitle()['title'] ?? null }}</h4>
                        <span></span>
                    </div>
                    <div class="row">
                        @foreach (SiteInfo::brands() as $brandKey => $brand)
                            <div
                                class="col-sm-6 @if ($brandKey == 0 || $brandKey == 1) col-md-6 @else col-md-3 @endif text-center">
                                <a href="#" class="pic-area">
                                    <img src="{{ asset($brand->image) }}" alt="">
                                </a>
                            </div>
                            <div class="col-sm-6 col-md-3">
                                <a href="javascript:void(0)" class="pic-area">
                                    <img src="{{ asset($brand->image) }}"
                                        alt="">
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif
    </div> --}}
    <div class="copyright-area">
        <div class="container">
            <div class="row">
                <div class="text-center">
                    <div class="copyright-text">
                        <p>{{ str_replace('[[YEAR]]', date('Y'), SiteInfo::info()['copyright']) }} {!! SiteInfo::info()['footer_text'] !!}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>

@include('frontend.layout.js')
{{--<script>
    feather.replace();
</script>--}}
@stack('scripts')
<script>
    document.getElementById("myForm").addEventListener("submit", function (event) {
        event.preventDefault(); // Prevent immediate submission

        // Check if reCAPTCHA is filled
        const recaptchaResponse = grecaptcha.getResponse();

        if (!recaptchaResponse) {
            Swal.fire({
                icon: "error",
                title: "Oops...",
                text: "Please complete the reCAPTCHA!"
            });
            return false;
        }

        // If reCAPTCHA is valid, submit the form
        this.submit();
    });
    $('.project_slider').owlCarousel({
        rtl: true,
        loop: true,
        margin: 10,
        nav: true,
        autoplay: true,
        responsive: {
            0: {
                items: 1
            },
            600: {
                items: 3
            },
            1000: {
                items: 5
            }
        }
    })
    let count = 0;


    function myFunction() {
        // document.getElementById("myDropdown").classList.toggle("show");
        count++;
        if (count % 2 == 0) {
            $(".dropdown-content").css({
                'display': 'none'
            });
        } else {
            $(".dropdown-content").css({
                'display': 'block'
            });
        }
    }

    function myUserFunction() {
        // document.getElementById("myDropdown").classList.toggle("show");
        count++;
        if (count % 2 == 0) {
            $(".dropdown-content2").css({
                'display': 'none'
            });
        } else {
            $(".dropdown-content2").css({
                'display': 'block'
            });
        }
    }

    // // Close the dropdown if the user clicks outside of it
    // const dropdownBtn = document.getElementsByClassName("dropbtn");
    // const dropdownMenu = document.getElementById("myDropdown");


    // // Close dropdown when clicking anywhere outside the dropdown
    // document.addEventListener("click", function(event) {
    //     if (!dropdownBtn.contains(event.target) && !dropdownMenu.contains(event.target)) {
    //         dropdownMenu.style.display = "none";
    //     }
    // });
    // window.onclick = function(event) {
    //     if (!event.target.matches('.dropbtn')) {
    //         var dropdowns = document.getElementsByClassName("dropdown-content");
    //         var i;
    //         for (i = 0; i < dropdowns.length; i++) {
    //             var openDropdown = dropdowns[i];
    //             if (openDropdown.classList.contains('show')) {
    //                 openDropdown.classList.remove('show');
    //             }
    //         }
    //     }
    // }

    function myFunctionGallery() {
        count++;
        if (count % 2 == 0) {
            $(".dropdown-content1").css({
                'display': 'none'
            });
        } else {
            $(".dropdown-content1").css({
                'display': 'block'
            });
        }
        // document.getElementById("myDropdown").classList.toggle("show");
    }

    // Close the dropdown if the user clicks outside of it
    window.onclick = function (event) {
        if (!event.target.matches('.dropbtn')) {
            var dropdowns = document.getElementsByClassName("dropdown-content");
            var i;
            for (i = 0; i < dropdowns.length; i++) {
                var openDropdown = dropdowns[i];
                if (openDropdown.classList.contains('show')) {
                    openDropdown.classList.remove('show');
                }
            }
        }
    }
    window.onclick = function (event) {
        if (!event.target.matches('.dropbtn')) {
            var dropdowns = document.getElementsByClassName("dropdown-content1");
            var i;
            for (i = 0; i < dropdowns.length; i++) {
                var openDropdown = dropdowns[i];
                if (openDropdown.classList.contains('show')) {
                    openDropdown.classList.remove('show');
                }
            }
        }
    }
    window.onclick = function (event) {
        if (!event.target.matches('.dropbtn')) {
            var dropdowns = document.getElementsByClassName("dropdown-content2");
            var i;
            for (i = 0; i < dropdowns.length; i++) {
                var openDropdown = dropdowns[i];
                if (openDropdown.classList.contains('show')) {
                    openDropdown.classList.remove('show');
                }
            }
        }
    }
    $(document).ready(() => {
        $('.js-example-basic-single').select2();
        @if (Session::has('success'))
        setTimeout(() => {
            toastr.success("{{ Session::get('success') }}");
        }, 2000);
        @endif
        @if (Session::has('error'))
        setTimeout(() => {
            toastr.error("{{ Session::get('error') }}");
        }, 2000);
        @endif
    });
    const manageQuantity = (cart_id, quantity) => {
        if (!!quantity === true) {
            $.ajax({
                url: "{{ route('frontend.update.cart') }}",
                type: "post",
                data: {
                    _token: '{{ csrf_token() }}',
                    cart_id,
                    quantity
                },
                success: function (response) {
                    console.log(response);
                    if (response.status == 'success') {
                        toastr.success(response.msg, 'Success!');
                        // $('#accordionExample').html(response.html);
                        // $("#collapseOne").addClass('show');
                        setTimeout(() => {
                            location.reload();
                        }, 2000);
                    } else {
                        toastr.error(response.msg, 'Warning!');
                    }
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                }
            });
        }
    }
    const removeItem = (cart_id) => {
        $.ajax({
            url: "{{ route('frontend.remove.cart') }}",
            type: "post",
            data: {
                _token: '{{ csrf_token() }}',
                cart_id
            },
            success: function (response) {
                if (response.status == 'success') {
                    toastr.success(response.msg, 'Success!');
                    // $('#accordionExample').html(response.html);
                    // $("#collapseOne").addClass('show');
                    setTimeout(() => {
                        location.reload();
                    }, 2000);
                } else {
                    toastr.error(response.msg, 'Warning!');
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                console.log(textStatus, errorThrown);
            }
        });
    }

    function debounce(func, timeout = 1500) {
        let timer;
        return (...args) => {
            clearTimeout(timer);
            timer = setTimeout(() => {
                func.apply(this, args);
            }, timeout);
        };
    }

    function search() {
        let route = '{{ route('frontend.searchType') }}';
        let search_product = $("#search_product").val();
        search_product = search_product.toLowerCase().replace(/ /g, "-").replace(/[^\w-]+/g, "");
        route = `${route}?query=${search_product}`;
        window.location.href = route;
    }

    const searchProducts = debounce(() => search());
</script>
@stack('scripts')
</body>

</html>
