@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <div class="breadcrumb-sec">
        <div class="container">
            <ul>
                <li><a href="{{ route('frontend.index') }}">Home</a></li>
                <li><span>/</span></li>
                <li>General Assembly</li>
            </ul>
        </div>
    </div>
    <!-- ====== Shopping Cart Start ====== -->
    @if (!empty($generalAssemblies))
        <div class="assembly-main-sec">
            <div class="main-healine-area01">
                <div class="container">
                    <h2>{{ SiteInfo::title()['assembly_title'] ?? null }}</h2>
                    <p>{{ SiteInfo::title()['assembly_description'] ?? null }}</p>
                </div>
                <div class="video-card-area">
                    <div class="container">
                        <div class="row">
                            @foreach ($generalAssemblies as $generalAssembly)
                                <div class="col-md-3">
                                    <div class="card-item">
                                        <a href="#" class="image-item">
                                            <img src="{{ asset($generalAssembly->image) }}" alt="">
                                        </a>
                                        <h4>{{ $generalAssembly->name }}</h4>
                                        <a href="{{ route('frontend.generalAssemblyVideo', $generalAssembly->id) }}"
                                            class="btn">View Videos</a>
                                    </div>
                                </div>
                            @endforeach

                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection
