@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <div class="breadcrumb-sec">
        <div class="container">
            <ul>
                <li><a href="{{ route('frontend.index') }}">Home</a></li>
                <li><span>/</span></li>
                <li><a href="{{ route('frontend.assembly_isntructions') }}">General Assembly</a></li>
                <li><span>/</span></li>
                <li>{{ $generalAssembly->name }}</li>
            </ul>
        </div>
    </div>
    <!-- ====== Shopping Cart Start ====== -->
    @if (!empty($generalAssemblyVideos))
        <div class="assembly-main-sec">
            <div class="main-healine-area01">
                <div class="container">
                    <h2>General Assembly Videos for {{ $generalAssembly->name }}</h2>
                </div>
                <div class="video-card-area">
                    <div class="container">
                        <div class="row">
                            @foreach ($generalAssemblyVideos as $generalAssemblyVideo)
                                <div class="col-md-3">
                                    <div class="card-item">
                                        <a href="#" class="image-item">
                                            <img src="{{ asset($generalAssemblyVideo->image) }}" alt="">
                                        </a>
                                        <h4>{{ $generalAssemblyVideo->name }}</h4>
                                        <a href="{{ $generalAssemblyVideo->youtube_link }}" target="_blank"
                                            class="btn">View Videos</a>
                                    </div>
                                </div>
                            @endforeach

                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection
