@extends('frontend.layout.layout')
@section('meta_tag')
    <title>{{ SiteInfo::info()['site_name'] }}</title>
@endsection
@section('content')
    <div class="breadcrumb-sec">
        <div class="container">
            <ul>
                <li><a href="{{ route('frontend.index') }}">Home</a></li>
                <li><span>/</span></li>
                <li>Blogs</li>
            </ul>
        </div>
    </div>
    @if (count($blogs) > 0)
        <div class="blog-main-sec">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 col-lg-9">
                        <div class="row">
                            @foreach ($blogs as $blog)
                                <div class="col-md-6 col-lg-4">
                                    <div class="card">
                                        <a href="{{ route('frontend.blog_details', ['slug' => $blog->slug]) }}">
                                            <div class="card-header">
                                                <img src="{{ asset($blog->image) }}" alt="" loading="lazy"/>
                                            </div>
                                            <div class="card-body">@php
                                                if (strlen($blog->title) > 30) {
                                                    $title = substr($blog->title, 0, 30) . '...';
                                                } else {
                                                    $title = $blog->title;
                                                }
                                            @endphp
                                                <h4> <a
                                                        href="{{ route('frontend.blog_details', ['slug' => $blog->slug]) }}">{{ $title }}</a>
                                                </h4>
                                                <p>
                                                    @php
                                                        if (strlen(strip_tags($blog->description)) > 100) {
                                                            $description =
                                                                substr(strip_tags($blog->description), 0, 100) . '...';
                                                        } else {
                                                            $description = strip_tags($blog->description);
                                                        }
                                                    @endphp
                                                    {!! $description !!}
                                                </p>
                                                <strong>
                                                    {{ Carbon\Carbon::parse($blog->date)->format('F d,Y') }}</strong>
                                            </div>

                                        </a>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="d-flex justify-content-center">
                            {!! $blogs->links('pagination::bootstrap-5') !!}
                        </div>
                    </div>
                    @if (!empty($relatedblogs))
                        <div class="col-md-4 col-lg-3">
                            <div class="category-group">
                                <div class="subHeadline">
                                    <h3>Blogs</h3>
                                </div>
                                <div class="category-group">
                                    <div class="category-group-area">

                                        <div class="blog-list">
                                            <ul>
                                                @foreach ($relatedblogs as $relatedblog)
                                                    <li><a class="postitem"
                                                            href="{{ route('frontend.blog_details', ['slug' => $relatedblog->slug]) }}">
                                                            <div class="picarea"><img alt="" class="img"
                                                                    src="{{ asset($relatedblog->image) }}"></div>
                                                            <div class="postinfo">@php
                                                                if (strlen($relatedblog->title) > 30) {
                                                                    $title1 =
                                                                        substr($relatedblog->title, 0, 30) . '...';
                                                                } else {
                                                                    $title1 = $blog->title;
                                                                }
                                                            @endphp
                                                                <h5>{{ $title1 }}</h5>
                                                                <p>{{ Carbon\Carbon::parse($relatedblog->date)->format('F d,Y') }}
                                                                </p>
                                                            </div>
                                                        </a></li>
                                                @endforeach


                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>




            </div>
        </div>
    @endif
@endsection
